/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene91.Lucene91Codec;
import org.opensearch.knn.index.codec.KNN910Codec.KNN910Codec;

public class KNNCodecFactory {
    private static Map<KNNCodecVersion, Class> CODEC_BY_VERSION = ImmutableMap.of((Object)((Object)KNNCodecVersion.KNN910), KNN910Codec.class);
    private static KNNCodecVersion LATEST_KNN_CODEC_VERSION = KNNCodecVersion.KNN910;

    public static Codec createKNNCodec(Codec userCodec) {
        return KNNCodecFactory.getCodec(LATEST_KNN_CODEC_VERSION, userCodec);
    }

    public static Codec createKNNCodec(KNNCodecVersion knnCodecVersion, Codec userCodec) {
        return KNNCodecFactory.getCodec(knnCodecVersion, userCodec);
    }

    private static Codec getCodec(KNNCodecVersion knnCodecVersion, Codec userCodec) {
        try {
            Constructor constructor = CODEC_BY_VERSION.getOrDefault((Object)knnCodecVersion, CODEC_BY_VERSION.get((Object)LATEST_KNN_CODEC_VERSION)).getConstructor(Codec.class);
            return (Codec)constructor.newInstance(userCodec);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot create instance of KNN codec", ex);
        }
    }

    static enum KNNCodecVersion {
        KNN910;

    }

    public static class CodecDelegateFactory {
        public static Codec createKNN91DefaultDelegate() {
            return new Lucene91Codec();
        }
    }
}

