/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.ValidationException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.knn.index.MethodComponentContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.KNNEngine;

public class KNNMethodContext
implements ToXContentFragment,
Writeable {
    private static final Logger logger = LogManager.getLogger(KNNMethodContext.class);
    private static KNNMethodContext defaultInstance = null;
    private final KNNEngine knnEngine;
    private final SpaceType spaceType;
    private final MethodComponentContext methodComponent;

    public static synchronized KNNMethodContext getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new KNNMethodContext(KNNEngine.DEFAULT, SpaceType.DEFAULT, new MethodComponentContext("hnsw", Collections.emptyMap()));
        }
        return defaultInstance;
    }

    public KNNMethodContext(KNNEngine knnEngine, SpaceType spaceType, MethodComponentContext methodComponent) {
        this.knnEngine = knnEngine;
        this.spaceType = spaceType;
        this.methodComponent = methodComponent;
    }

    public KNNMethodContext(StreamInput in) throws IOException {
        this.knnEngine = KNNEngine.getEngine(in.readString());
        this.spaceType = SpaceType.getSpace(in.readString());
        this.methodComponent = new MethodComponentContext(in);
    }

    public MethodComponentContext getMethodComponent() {
        return this.methodComponent;
    }

    public KNNEngine getEngine() {
        return this.knnEngine;
    }

    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    public ValidationException validate() {
        return this.knnEngine.validateMethod(this);
    }

    public boolean isTrainingRequired() {
        return this.knnEngine.isTrainingRequired(this);
    }

    public int estimateOverheadInKB(int dimension) {
        return this.knnEngine.estimateOverheadInKB(this, dimension);
    }

    public static KNNMethodContext parse(Object in) {
        if (!(in instanceof Map)) {
            throw new MapperParsingException("Unable to parse mapping into KNNMethodContext. Object not of type \"Map\"");
        }
        Map methodMap = (Map)in;
        KNNEngine engine = KNNEngine.DEFAULT;
        SpaceType spaceType = SpaceType.DEFAULT;
        String name = "";
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry methodEntry : methodMap.entrySet()) {
            String key = (String)methodEntry.getKey();
            Object value = methodEntry.getValue();
            if ("engine".equals(key)) {
                if (value != null && !(value instanceof String)) {
                    throw new MapperParsingException("\"engine\" must be a string");
                }
                if (value == null) continue;
                try {
                    engine = KNNEngine.getEngine((String)value);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new MapperParsingException("Invalid engine: " + value);
                }
            }
            if ("space_type".equals(key)) {
                if (value != null && !(value instanceof String)) {
                    throw new MapperParsingException("\"space_type\" must be a string");
                }
                try {
                    spaceType = SpaceType.getSpace((String)value);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new MapperParsingException("Invalid space_type: " + value);
                }
            }
            if ("name".equals(key)) {
                if (!(value instanceof String)) {
                    throw new MapperParsingException("namehas to be a string");
                }
                name = (String)value;
                continue;
            }
            if ("parameters".equals(key)) {
                if (value == null) {
                    parameters = null;
                    continue;
                }
                if (!(value instanceof Map)) {
                    throw new MapperParsingException("Unable to parse parameters for main method component");
                }
                Map<String, Object> parameters1 = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                    Object v = e.getValue();
                    if (v instanceof Map) {
                        return MethodComponentContext.parse(v);
                    }
                    return v;
                }));
                parameters = parameters1;
                continue;
            }
            throw new MapperParsingException("Invalid parameter: " + key);
        }
        if (name.isEmpty()) {
            throw new MapperParsingException("name needs to be set");
        }
        MethodComponentContext method = new MethodComponentContext(name, parameters);
        return new KNNMethodContext(engine, spaceType, method);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("engine", this.knnEngine.getName());
        builder.field("space_type", this.spaceType.getValue());
        builder = this.methodComponent.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KNNMethodContext other = (KNNMethodContext)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.knnEngine, (Object)other.knnEngine);
        equalsBuilder.append((Object)this.spaceType, (Object)other.spaceType);
        equalsBuilder.append((Object)this.methodComponent, (Object)other.methodComponent);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.knnEngine).append((Object)this.spaceType).append((Object)this.methodComponent).toHashCode();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.knnEngine.getName());
        out.writeString(this.spaceType.getValue());
        this.methodComponent.writeTo(out);
    }
}

