/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.utils.LogUtils;

public class RestQuerySettingsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestQuerySettingsAction.class);
    private static final String PERSISTENT = "persistent";
    private static final String TRANSIENT = "transient";
    private static final String SQL_SETTINGS_PREFIX = "plugins.sql.";
    private static final String PPL_SETTINGS_PREFIX = "plugins.ppl.";
    private static final String COMMON_SETTINGS_PREFIX = "plugins.query.";
    private static final String LEGACY_SQL_SETTINGS_PREFIX = "opendistro.sql.";
    private static final String LEGACY_PPL_SETTINGS_PREFIX = "opendistro.ppl.";
    private static final String LEGACY_COMMON_SETTINGS_PREFIX = "opendistro.query.";
    private static final List<String> SETTINGS_PREFIX = ImmutableList.of((Object)"plugins.sql.", (Object)"plugins.ppl.", (Object)"plugins.query.", (Object)"opendistro.sql.", (Object)"opendistro.ppl.", (Object)"opendistro.query.");
    public static final String SETTINGS_API_ENDPOINT = "/_plugins/_query/settings";
    public static final String LEGACY_SQL_SETTINGS_API_ENDPOINT = "/_opendistro/_sql/settings";

    public RestQuerySettingsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "ppl_settings_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.PUT, SETTINGS_API_ENDPOINT, RestRequest.Method.PUT, LEGACY_SQL_SETTINGS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map source;
        LogUtils.addRequestId();
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = Requests.clusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.timeout(request.paramAsTime("timeout", clusterUpdateSettingsRequest.timeout()));
        clusterUpdateSettingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterUpdateSettingsRequest.masterNodeTimeout()));
        try (XContentParser parser = request.contentParser();){
            source = parser.map();
        }
        try {
            if (source.containsKey(TRANSIENT)) {
                clusterUpdateSettingsRequest.transientSettings(this.getAndFilterSettings((Map)source.get(TRANSIENT)));
            }
            if (source.containsKey(PERSISTENT)) {
                clusterUpdateSettingsRequest.persistentSettings(this.getAndFilterSettings((Map)source.get(PERSISTENT)));
            }
            return channel -> client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Exception e) {
            LOG.error("Error changing OpenSearch SQL plugin cluster settings", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ErrorMessageFactory.createErrorMessage((Exception)e, (int)RestStatus.INTERNAL_SERVER_ERROR.getStatus()).toString()));
        }
    }

    private Settings getAndFilterSettings(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
            builder.map(source);
            Settings.Builder settingsBuilder = Settings.builder().loadFromSource(Strings.toString((XContentBuilder)builder), builder.contentType());
            settingsBuilder.keys().removeIf(key -> {
                for (String prefix : SETTINGS_PREFIX) {
                    if (!key.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            });
            return settingsBuilder.build();
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + source + "]", (Throwable)e);
        }
    }
}

