/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.LogUtils;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.QueryEngineException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.plugin.request.PPLQueryRequestFactory;
import org.opensearch.sql.plugin.rest.OpenSearchPluginConfig;
import org.opensearch.sql.ppl.PPLService;
import org.opensearch.sql.ppl.config.PPLServiceConfig;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.CsvResponseFormatter;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.RawResponseFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;
import org.opensearch.sql.protocol.response.format.SimpleJsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.VisualizationResponseFormatter;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class RestPPLQueryAction
extends BaseRestHandler {
    public static final String QUERY_API_ENDPOINT = "/_plugins/_ppl";
    public static final String EXPLAIN_API_ENDPOINT = "/_plugins/_ppl/_explain";
    public static final String LEGACY_QUERY_API_ENDPOINT = "/_opendistro/_ppl";
    public static final String LEGACY_EXPLAIN_API_ENDPOINT = "/_opendistro/_ppl/_explain";
    private static final Logger LOG = LogManager.getLogger();
    private final ClusterService clusterService;
    private final org.opensearch.sql.common.setting.Settings pluginSettings;
    private final Supplier<Boolean> pplEnabled;

    public RestPPLQueryAction(RestController restController, ClusterService clusterService, org.opensearch.sql.common.setting.Settings pluginSettings, Settings clusterSettings) {
        this.clusterService = clusterService;
        this.pluginSettings = pluginSettings;
        this.pplEnabled = () -> (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(clusterSettings) != false && (Boolean)pluginSettings.getSettingValue(Settings.Key.PPL_ENABLED) != false;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Arrays.asList(new RestHandler.ReplacedRoute(RestRequest.Method.POST, QUERY_API_ENDPOINT, RestRequest.Method.POST, LEGACY_QUERY_API_ENDPOINT), new RestHandler.ReplacedRoute(RestRequest.Method.POST, EXPLAIN_API_ENDPOINT, RestRequest.Method.POST, LEGACY_EXPLAIN_API_ENDPOINT));
    }

    public String getName() {
        return "ppl_query_action";
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_COUNT_TOTAL).increment();
        LogUtils.addRequestId();
        if (!this.pplEnabled.get().booleanValue()) {
            return channel -> this.reportError((RestChannel)channel, new IllegalAccessException("Either plugins.ppl.enabled or rest.action.multi.allow_explicit_index setting is false"), RestStatus.BAD_REQUEST);
        }
        PPLService pplService = this.createPPLService(nodeClient);
        PPLQueryRequest pplRequest = PPLQueryRequestFactory.getPPLRequest(request);
        if (pplRequest.isExplainRequest()) {
            return channel -> pplService.explain(pplRequest, this.createExplainResponseListener((RestChannel)channel));
        }
        return channel -> pplService.execute(pplRequest, this.createListener((RestChannel)channel, pplRequest));
    }

    private PPLService createPPLService(NodeClient client) {
        return this.doPrivileged(() -> {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            context.registerBean(ClusterService.class, () -> this.clusterService, new BeanDefinitionCustomizer[0]);
            context.registerBean(NodeClient.class, () -> client, new BeanDefinitionCustomizer[0]);
            context.registerBean(org.opensearch.sql.common.setting.Settings.class, () -> this.pluginSettings, new BeanDefinitionCustomizer[0]);
            context.register(new Class[]{OpenSearchPluginConfig.class});
            context.register(new Class[]{PPLServiceConfig.class});
            context.refresh();
            return (PPLService)context.getBean(PPLService.class);
        });
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final RestChannel channel) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            public void onResponse(ExecutionEngine.ExplainResponse response) {
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.OK, new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                }.format((Object)response));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during explain", (Throwable)e);
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, "Failed to explain the query due to error: " + e.getMessage());
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createListener(final RestChannel channel, PPLQueryRequest pplRequest) {
        Format format = pplRequest.format();
        Object formatter = format.equals((Object)Format.CSV) ? new CsvResponseFormatter(pplRequest.sanitize()) : (format.equals((Object)Format.RAW) ? new RawResponseFormatter() : (format.equals((Object)Format.VIZ) ? new VisualizationResponseFormatter(pplRequest.style()) : new SimpleJsonResponseFormatter(JsonResponseFormatter.Style.PRETTY)));
        return new ResponseListener<ExecutionEngine.QueryResponse>(){
            final /* synthetic */ ResponseFormatter val$formatter;
            {
                this.val$formatter = responseFormatter;
            }

            public void onResponse(ExecutionEngine.QueryResponse response) {
                RestPPLQueryAction.this.sendResponse(channel, RestStatus.OK, this.val$formatter.format((Object)new QueryResult(response.getSchema(), (Collection)response.getResults())));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during query handling", (Throwable)e);
                if (RestPPLQueryAction.isClientError(e)) {
                    Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_CUS).increment();
                    RestPPLQueryAction.this.reportError(channel, e, RestStatus.BAD_REQUEST);
                } else {
                    Metrics.getInstance().getNumericalMetric(MetricName.PPL_FAILED_REQ_COUNT_SYS).increment();
                    RestPPLQueryAction.this.reportError(channel, e, RestStatus.SERVICE_UNAVAILABLE);
                }
            }
        };
    }

    private <T> T doPrivileged(PrivilegedExceptionAction<T> action) {
        try {
            return (T)SecurityAccess.doPrivileged(action);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to perform privileged action", e);
        }
    }

    private void sendResponse(RestChannel channel, RestStatus status, String content) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, "application/json; charset=UTF-8", content));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, ErrorMessageFactory.createErrorMessage((Throwable)e, (int)status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof NullPointerException || e instanceof IllegalArgumentException || e instanceof IndexNotFoundException || e instanceof SemanticCheckException || e instanceof ExpressionEvaluationException || e instanceof QueryEngineException || e instanceof SyntaxCheckException;
    }
}

