/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.anomalylocalization;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.action.NotifyOnceListener;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.anomalylocalization.AnomalyLocalizationInput;
import org.opensearch.ml.common.output.Output;
import org.opensearch.ml.common.output.execute.anomalylocalization.AnomalyLocalizationOutput;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;
import org.opensearch.ml.engine.Executable;
import org.opensearch.ml.engine.algorithms.anomalylocalization.AnomalyLocalizer;
import org.opensearch.ml.engine.algorithms.anomalylocalization.HybridCounter;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.filter.Filters;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.builder.SearchSourceBuilder;

public class AnomalyLocalizerImpl
implements AnomalyLocalizer,
Executable {
    @Generated
    private static final Logger log = LogManager.getLogger(AnomalyLocalizerImpl.class);
    protected static final double MIN_DIFF_PCT = 0.01;
    protected static final int MAX_TIME_BUCKETS = 8;
    protected static final int MIN_CONTRIBUTOR_CANDIDATE = 100;
    private final Client client;
    private final Settings settings;

    public AnomalyLocalizerImpl(Client client, Settings settings) {
        this.client = client;
        this.settings = settings;
    }

    @Override
    public void getLocalizationResults(AnomalyLocalizationInput input, ActionListener<AnomalyLocalizationOutput> listener) {
        AnomalyLocalizationOutput output = new AnomalyLocalizationOutput();
        input.getAggregations().stream().forEach(agg -> this.localizeByBuckets(input, (AggregationBuilder)agg, output, (ActionListener<AnomalyLocalizationOutput>)this.notifyOnce(listener)));
    }

    private void localizeByBuckets(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        LocalizationTimeBuckets timeBuckets = this.getTimeBuckets(input);
        this.getOverallAggregates(input, timeBuckets, agg, output, listener);
    }

    private void getOverallAggregates(AnomalyLocalizationInput input, LocalizationTimeBuckets timeBuckets, AggregationBuilder agg, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        MultiSearchRequest searchRequest = this.newSearchRequestForOverallAggregates(input, agg, timeBuckets);
        this.client.multiSearch(searchRequest, ActionListener.wrap(r -> this.onOverallAggregatesResponse((MultiSearchResponse)r, input, agg, output, timeBuckets, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onOverallAggregatesResponse(MultiSearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput output, LocalizationTimeBuckets timeBuckets, ActionListener<AnomalyLocalizationOutput> listener) {
        AnomalyLocalizationOutput.Result result = new AnomalyLocalizationOutput.Result();
        List<Map.Entry<Long, Long>> intervals = timeBuckets.getAllIntervals();
        for (int i = 0; i < intervals.size(); ++i) {
            double value = this.getDoubleValue((NumericMetricsAggregation.SingleValue)response.getResponses()[i].getResponse().getAggregations().get(agg.getName()));
            AnomalyLocalizationOutput.Bucket bucket = new AnomalyLocalizationOutput.Bucket();
            bucket.setStartTime(intervals.get(i).getKey().longValue());
            bucket.setEndTime(intervals.get(i).getValue().longValue());
            bucket.setOverallAggValue(value);
            result.getBuckets().add(bucket);
        }
        output.getResults().put(agg.getName(), result);
        this.getLocalizedEntities(input, agg, result, output, listener);
    }

    private void getLocalizedEntities(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        if (this.setBase(result, input)) {
            HybridCounter counter = new HybridCounter();
            result.getBuckets().stream().filter(e -> e.getBase().isPresent() && ((AnomalyLocalizationOutput.Bucket)e.getBase().get()).equals(e)).forEach(e -> this.processBaseEntry(input, agg, result, (AnomalyLocalizationOutput.Bucket)e, counter, Optional.empty(), output, listener));
        }
        this.outputIfResultsAreComplete(output, listener);
    }

    private void outputIfResultsAreComplete(AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        if (output.getResults().values().stream().allMatch(this::isResultComplete)) {
            listener.onResponse((Object)output);
        }
    }

    private boolean isResultComplete(AnomalyLocalizationOutput.Result result) {
        return result.getBuckets().stream().allMatch(e -> e.getCompleted() == null || e.getCompleted().get());
    }

    private void processBaseEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Counter counter, Optional<Map<String, Object>> afterKey, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        SearchRequest request = this.newSearchRequestForEntry(input, agg, bucket, afterKey);
        this.client.search(request, ActionListener.wrap(r -> this.onBaseEntryResponse((SearchResponse)r, input, agg, result, bucket, counter, output, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onBaseEntryResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Counter counter, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        Optional<CompositeAggregation> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (CompositeAggregation)aggs.get(agg.getName()));
        respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList()).stream().forEach(b -> counter.increment(this.toStringKey(b.getKey(), input), this.getDoubleValue((NumericMetricsAggregation.SingleValue)b.getAggregations().get(agg.getName()))));
        Optional<Map<String, Object>> afterKey = respAgg.map(r -> r.afterKey());
        if (afterKey.isPresent()) {
            this.processBaseEntry(input, agg, result, bucket, counter, afterKey, output, listener);
        } else {
            bucket.setCounter(Optional.of(counter));
            result.getBuckets().stream().filter(e -> e.getCompleted() != null && !e.getCompleted().get()).forEach(e -> {
                int queueSize = Math.max(input.getNumOutputs(), 100);
                PriorityQueue<Object> queue = e.getOverallAggValue() > 0.0 ? new PriorityQueue<AnomalyLocalizationOutput.Entity>(queueSize, (a, b) -> (int)Math.signum(a.getContributionValue() - b.getContributionValue())) : new PriorityQueue(queueSize, (a, b) -> (int)Math.signum(b.getContributionValue() - a.getContributionValue()));
                this.processNewEntry(input, agg, result, (AnomalyLocalizationOutput.Bucket)e, Optional.empty(), (PriorityQueue<AnomalyLocalizationOutput.Entity>)queue, output, listener);
            });
        }
    }

    private void processNewEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, Optional<Map<String, Object>> afterKey, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        SearchRequest request = this.newSearchRequestForEntry(input, agg, bucket, afterKey);
        this.client.search(request, ActionListener.wrap(r -> this.onNewEntryResponse((SearchResponse)r, input, agg, result, bucket, queue, output, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void onNewEntryResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket outputBucket, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        Optional<CompositeAggregation> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (CompositeAggregation)aggs.get(agg.getName()));
        for (CompositeAggregation.Bucket bucket : respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList())) {
            List<String> key = this.toStringKey(bucket.getKey(), input);
            AnomalyLocalizationOutput.Entity entity = new AnomalyLocalizationOutput.Entity();
            entity.setKey(key);
            entity.setNewValue(this.getDoubleValue((NumericMetricsAggregation.SingleValue)bucket.getAggregations().get(agg.getName())));
            entity.setBaseValue(((Counter)((AnomalyLocalizationOutput.Bucket)outputBucket.getBase().get()).getCounter().get()).estimate(key));
            entity.setContributionValue(entity.getNewValue() - entity.getBaseValue());
            if (queue.size() < input.getNumOutputs()) {
                queue.add(entity);
                continue;
            }
            if (queue.comparator().compare(queue.peek(), entity) >= 0) continue;
            queue.poll();
            queue.add(entity);
        }
        Optional<Map<String, Object>> afterKey = respAgg.map(r -> r.afterKey());
        if (afterKey.isPresent()) {
            this.processNewEntry(input, agg, result, outputBucket, afterKey, queue, output, listener);
        } else {
            List<List<String>> keys = queue.stream().map(AnomalyLocalizationOutput.Entity::getKey).collect(Collectors.toList());
            SearchRequest request = this.newSearchRequestForEntityKeys(input, agg, outputBucket, keys);
            this.client.search(request, ActionListener.wrap(r -> this.onEntityKeysResponse((SearchResponse)r, input, agg, result, outputBucket, queue, output, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void onEntityKeysResponse(SearchResponse response, AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Result result, AnomalyLocalizationOutput.Bucket bucket, PriorityQueue<AnomalyLocalizationOutput.Entity> queue, AnomalyLocalizationOutput output, ActionListener<AnomalyLocalizationOutput> listener) {
        List<Object> entities = new ArrayList<AnomalyLocalizationOutput.Entity>(queue);
        Optional<Filters> respAgg = Optional.ofNullable(response.getAggregations()).map(aggs -> (Filters)aggs.get(agg.getName()));
        for (Filters.Bucket respBucket : respAgg.map(a -> a.getBuckets()).orElse(Collections.emptyList())) {
            int entityIndex = Integer.parseInt(respBucket.getKeyAsString());
            double aggValue = this.getDoubleValue((NumericMetricsAggregation.SingleValue)respBucket.getAggregations().get(agg.getName()));
            AnomalyLocalizationOutput.Entity entity2 = (AnomalyLocalizationOutput.Entity)entities.get(entityIndex);
            entity2.setBaseValue(aggValue);
            entity2.setContributionValue(entity2.getNewValue() - entity2.getBaseValue());
        }
        double newChangeSign = Math.signum(bucket.getOverallAggValue() - ((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getOverallAggValue());
        entities = entities.stream().filter(entity -> Math.signum(entity.getContributionValue()) == newChangeSign).sorted(queue.comparator().reversed()).collect(Collectors.toList());
        bucket.setEntities(entities);
        bucket.getCompleted().set(true);
        this.outputIfResultsAreComplete(output, listener);
    }

    private SearchRequest newSearchRequestForEntityKeys(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Bucket bucket, List<List<String>> keys) {
        RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from((Object)((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getStartTime(), true).to((Object)((AnomalyLocalizationOutput.Bucket)bucket.getBase().get()).getEndTime(), true);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
        input.getFilterQuery().ifPresent(q -> filter.filter(q));
        FiltersAggregator.KeyedFilter[] filters = (FiltersAggregator.KeyedFilter[])IntStream.range(0, keys.size()).mapToObj(i -> new FiltersAggregator.KeyedFilter(Integer.toString(i), (QueryBuilder)this.newQueryByKey((List)keys.get(i), input))).toArray(FiltersAggregator.KeyedFilter[]::new);
        FiltersAggregationBuilder filtersAgg = AggregationBuilders.filters((String)agg.getName(), (FiltersAggregator.KeyedFilter[])filters);
        filtersAgg.subAggregation(agg);
        SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation((AggregationBuilder)filtersAgg);
        SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
        return searchRequest;
    }

    private BoolQueryBuilder newQueryByKey(List<String> key, AnomalyLocalizationInput input) {
        BoolQueryBuilder bool = new BoolQueryBuilder();
        IntStream.range(0, key.size()).forEach(i -> bool.filter((QueryBuilder)new TermQueryBuilder((String)input.getAttributeFieldNames().get(i), (String)key.get(i))));
        return bool;
    }

    private List<String> toStringKey(Map<String, Object> key, AnomalyLocalizationInput input) {
        return input.getAttributeFieldNames().stream().map(name -> key.get(name).toString()).collect(Collectors.toList());
    }

    private SearchRequest newSearchRequestForEntry(AnomalyLocalizationInput input, AggregationBuilder agg, AnomalyLocalizationOutput.Bucket bucket, Optional<Map<String, Object>> afterKey) {
        RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from((Object)bucket.getStartTime(), true).to((Object)bucket.getEndTime(), true);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
        input.getFilterQuery().ifPresent(q -> filter.filter(q));
        CompositeAggregationBuilder compositeAgg = new CompositeAggregationBuilder(agg.getName(), input.getAttributeFieldNames().stream().map(name -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(name).field(name)).collect(Collectors.toList())).size(((Integer)MultiBucketConsumerService.MAX_BUCKET_SETTING.get(this.settings)).intValue());
        compositeAgg.subAggregation(agg);
        if (afterKey.isPresent()) {
            compositeAgg.aggregateAfter(afterKey.get());
        }
        SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation((AggregationBuilder)compositeAgg);
        SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
        return searchRequest;
    }

    private boolean setBase(AnomalyLocalizationOutput.Result result, AnomalyLocalizationInput input) {
        boolean newEntry = false;
        List entries = result.getBuckets();
        int baseEntryIndex = 0;
        AnomalyLocalizationOutput.Bucket baseEntry = (AnomalyLocalizationOutput.Bucket)entries.get(baseEntryIndex);
        baseEntry.setBase(Optional.of(baseEntry));
        for (int i = 1; i < entries.size(); ++i) {
            AnomalyLocalizationOutput.Bucket currentEntry = (AnomalyLocalizationOutput.Bucket)entries.get(i);
            if (input.getAnomalyStartTime().isPresent()) {
                if (currentEntry.getEndTime() <= (Long)input.getAnomalyStartTime().get()) continue;
                currentEntry.setBase(Optional.of(baseEntry));
                currentEntry.setCompleted(new AtomicBoolean(false));
                newEntry = true;
                continue;
            }
            if (!(Math.abs(1.0 - currentEntry.getOverallAggValue() / baseEntry.getOverallAggValue()) > 0.01)) continue;
            currentEntry.setBase(Optional.of(baseEntry));
            currentEntry.setCompleted(new AtomicBoolean(false));
            newEntry = true;
        }
        return newEntry;
    }

    private MultiSearchRequest newSearchRequestForOverallAggregates(AnomalyLocalizationInput input, AggregationBuilder agg, LocalizationTimeBuckets timeBuckets) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        timeBuckets.getAllIntervals().stream().map(i -> {
            RangeQueryBuilder timeRangeFilter = new RangeQueryBuilder(input.getTimeFieldName()).from(i.getKey(), true).to(i.getValue(), true);
            BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)timeRangeFilter);
            input.getFilterQuery().ifPresent(q -> filter.filter(q));
            SearchSourceBuilder search = new SearchSourceBuilder().size(0).query((QueryBuilder)filter).aggregation(agg);
            SearchRequest searchRequest = new SearchRequest(new String[]{input.getIndexName()}, search);
            return searchRequest;
        }).forEach(arg_0 -> ((MultiSearchRequest)multiSearchRequest).add(arg_0));
        return multiSearchRequest;
    }

    private LocalizationTimeBuckets getTimeBuckets(AnomalyLocalizationInput input) {
        LocalizationTimeBuckets buckets;
        if (input.getEndTime() - input.getStartTime() < 2L * input.getMinTimeInterval()) {
            throw new IllegalArgumentException("Time range is too short");
        }
        if (input.getAnomalyStartTime().isPresent()) {
            long anomalyStart = (Long)input.getAnomalyStartTime().get();
            long end = Math.max(input.getEndTime(), anomalyStart + input.getMinTimeInterval());
            int numBuckets = Math.min((int)((end - anomalyStart) / input.getMinTimeInterval()), 7);
            long bucketInterval = (end - anomalyStart) / (long)numBuckets;
            long start = Math.min(input.getStartTime(), anomalyStart - bucketInterval);
            buckets = new LocalizationTimeBuckets(bucketInterval, start, IntStream.range(0, numBuckets).mapToLong(i -> anomalyStart + (long)i * bucketInterval).toArray());
        } else {
            int numBuckets = Math.min((int)((input.getEndTime() - input.getStartTime()) / input.getMinTimeInterval()), 8);
            long bucketIntervalMillis = (input.getEndTime() - input.getStartTime()) / (long)numBuckets;
            buckets = new LocalizationTimeBuckets(bucketIntervalMillis, input.getStartTime(), IntStream.rangeClosed(1, numBuckets - 1).mapToLong(i -> input.getStartTime() + (long)i * bucketIntervalMillis).toArray());
        }
        return buckets;
    }

    private <R> ActionListener<R> notifyOnce(final ActionListener<R> listener) {
        return new NotifyOnceListener<R>(){

            public void innerOnResponse(R r) {
                listener.onResponse(r);
            }

            public void innerOnFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private double getDoubleValue(NumericMetricsAggregation.SingleValue singleValue) {
        double value = singleValue.value();
        return Double.isFinite(value) ? value : 0.0;
    }

    @Override
    public Output execute(Input input) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference outRef = new AtomicReference();
        AtomicReference exRef = new AtomicReference();
        this.getLocalizationResults((AnomalyLocalizationInput)input, (ActionListener<AnomalyLocalizationOutput>)new LatchedActionListener(ActionListener.wrap(o -> outRef.set(o), e -> exRef.set(e)), latch));
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            throw new IllegalStateException(e2);
        }
        if (exRef.get() != null) {
            throw new RuntimeException((Throwable)exRef.get());
        }
        return (Output)outRef.get();
    }

    protected static class LocalizationTimeBuckets {
        private final long interval;
        private final long baseBucket;
        private final long[] newBuckets;

        protected List<Map.Entry<Long, Long>> getAllIntervals() {
            ArrayList<Map.Entry<Long, Long>> intervals = new ArrayList<Map.Entry<Long, Long>>(this.newBuckets.length + 1);
            intervals.add(new AbstractMap.SimpleEntry<Long, Long>(this.baseBucket, this.baseBucket + this.interval));
            Arrays.stream(this.newBuckets).forEach(t -> intervals.add(new AbstractMap.SimpleEntry<Long, Long>(t, t + this.interval)));
            return intervals;
        }

        @Generated
        public LocalizationTimeBuckets(long interval, long baseBucket, long[] newBuckets) {
            this.interval = interval;
            this.baseBucket = baseBucket;
            this.newBuckets = newBuckets;
        }

        @Generated
        public long getInterval() {
            return this.interval;
        }

        @Generated
        public long getBaseBucket() {
            return this.baseBucket;
        }

        @Generated
        public long[] getNewBuckets() {
            return this.newBuckets;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalizationTimeBuckets)) {
                return false;
            }
            LocalizationTimeBuckets other = (LocalizationTimeBuckets)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInterval() != other.getInterval()) {
                return false;
            }
            if (this.getBaseBucket() != other.getBaseBucket()) {
                return false;
            }
            return Arrays.equals(this.getNewBuckets(), other.getNewBuckets());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalizationTimeBuckets;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $interval = this.getInterval();
            result = result * 59 + (int)($interval >>> 32 ^ $interval);
            long $baseBucket = this.getBaseBucket();
            result = result * 59 + (int)($baseBucket >>> 32 ^ $baseBucket);
            result = result * 59 + Arrays.hashCode(this.getNewBuckets());
            return result;
        }

        @Generated
        public String toString() {
            return "AnomalyLocalizerImpl.LocalizationTimeBuckets(interval=" + this.getInterval() + ", baseBucket=" + this.getBaseBucket() + ", newBuckets=" + Arrays.toString(this.getNewBuckets()) + ")";
        }
    }
}

