/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.parkservices;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.IRCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.PredictorCorrector;
import com.amazon.randomcutforest.parkservices.RCFComputeDescriptor;
import com.amazon.randomcutforest.parkservices.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.parkservices.preprocessor.Preprocessor;
import com.amazon.randomcutforest.parkservices.threshold.BasicThresholder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import lombok.Generated;

public class ThresholdedRandomCutForest {
    IRCFComputeDescriptor lastAnomalyDescriptor;
    protected ForestMode forestMode = ForestMode.STANDARD;
    protected TransformMethod transformMethod = TransformMethod.NONE;
    protected RandomCutForest forest;
    protected PredictorCorrector predictorCorrector;
    protected IPreprocessor<AnomalyDescriptor> preprocessor;

    public ThresholdedRandomCutForest(Builder<?> builder) {
        this.forestMode = builder.forestMode;
        this.transformMethod = builder.transformMethod;
        Object preprocessorBuilder = ((Preprocessor.Builder)((Preprocessor.Builder)Preprocessor.builder().shingleSize(builder.shingleSize)).transformMethod(builder.transformMethod)).forestMode(builder.forestMode);
        if (builder.forestMode == ForestMode.TIME_AUGMENTED) {
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(builder.dimensions / builder.shingleSize);
            builder.dimensions += builder.shingleSize;
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(builder.normalizeTime);
            builder.internalShinglingEnabled = Optional.of(true);
        } else if (builder.forestMode == ForestMode.STREAMING_IMPUTE) {
            CommonUtils.checkArgument((builder.shingleSize > 1 ? 1 : 0) != 0, (String)" shingle size 1 is not useful in impute");
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(builder.dimensions / builder.shingleSize);
            ((Preprocessor.Builder)preprocessorBuilder).imputationMethod(builder.imputationMethod);
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(true);
            if (builder.fillValues != null) {
                ((Preprocessor.Builder)preprocessorBuilder).fillValues(builder.fillValues);
            }
            builder.internalShinglingEnabled = Optional.of(false);
            ((Preprocessor.Builder)preprocessorBuilder).useImputedFraction(builder.useImputedFraction.orElse(0.5));
        } else {
            boolean smallInput = builder.internalShinglingEnabled.orElse(false);
            ((Preprocessor.Builder)preprocessorBuilder).inputLength(smallInput ? builder.dimensions / builder.shingleSize : builder.dimensions);
        }
        this.forest = builder.buildForest();
        ((Preprocessor.Builder)preprocessorBuilder).weights(builder.weights);
        ((Preprocessor.Builder)preprocessorBuilder).weightTime(builder.weightTime.orElse(1.0));
        ((Preprocessor.Builder)preprocessorBuilder).timeDecay(this.forest.getTimeDecay());
        ((Preprocessor.Builder)preprocessorBuilder).dimensions(builder.dimensions);
        ((Preprocessor.Builder)preprocessorBuilder).stopNormalization(builder.stopNormalization.orElse(Preprocessor.DEFAULT_STOP_NORMALIZATION));
        ((Preprocessor.Builder)preprocessorBuilder).startNormalization(builder.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION));
        this.preprocessor = ((Preprocessor.Builder)preprocessorBuilder).build();
        this.predictorCorrector = new PredictorCorrector(new BasicThresholder(builder.anomalyRate, builder.adjustThreshold));
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, 0L, builder.forestMode, builder.transformMethod, builder.imputationMethod);
        if (builder.dimensions == builder.shingleSize || this.forestMode == ForestMode.TIME_AUGMENTED && builder.dimensions == 2 * builder.shingleSize) {
            if (builder.transformMethod != TransformMethod.NORMALIZE) {
                this.predictorCorrector.setLowerThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_LOWER_THRESHOLD_ONED));
            } else {
                this.predictorCorrector.setLowerThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_LOWER_THRESHOLD_NORMALIZED));
            }
            this.predictorCorrector.setHorizon(builder.horizon.orElse(BasicThresholder.DEFAULT_HORIZON_ONED));
        } else {
            if (builder.transformMethod != TransformMethod.NORMALIZE) {
                this.predictorCorrector.setLowerThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_LOWER_THRESHOLD));
            } else {
                this.predictorCorrector.setLowerThreshold(builder.lowerThreshold.orElse(BasicThresholder.DEFAULT_LOWER_THRESHOLD_NORMALIZED));
            }
            this.predictorCorrector.setHorizon(builder.horizon.orElse(BasicThresholder.DEFAULT_HORIZON));
        }
    }

    public ThresholdedRandomCutForest(ForestMode forestMode, TransformMethod transformMethod, RandomCutForest forest, PredictorCorrector predictorCorrector, Preprocessor preprocessor, RCFComputeDescriptor descriptor) {
        this.forestMode = forestMode;
        this.transformMethod = transformMethod;
        this.forest = forest;
        this.predictorCorrector = predictorCorrector;
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = descriptor;
    }

    public ThresholdedRandomCutForest(RandomCutForest forest, double futureAnomalyRate, List<Double> values) {
        this.forest = forest;
        this.predictorCorrector = new PredictorCorrector(new BasicThresholder(values, futureAnomalyRate));
        int dimensions = forest.getDimensions();
        int inputLength = forest.isInternalShinglingEnabled() ? dimensions / forest.getShingleSize() : forest.getDimensions();
        Preprocessor preprocessor = ((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)((Preprocessor.Builder)new Preprocessor.Builder().transformMethod(TransformMethod.NONE)).dimensions(dimensions)).shingleSize(forest.getShingleSize())).inputLength(inputLength)).build();
        preprocessor.setValuesSeen((int)forest.getTotalUpdates());
        preprocessor.getDataQuality().update(1.0);
        this.preprocessor = preprocessor;
        this.lastAnomalyDescriptor = new RCFComputeDescriptor(null, forest.getTotalUpdates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IRCFComputeDescriptor> T singleStepProcess(T input, IPreprocessor<T> preprocessor, Function<T, T> core) {
        IRCFComputeDescriptor answer;
        boolean ifZero = this.forest.getBoundingBoxCacheFraction() == 0.0;
        try {
            if (ifZero) {
                this.forest.setBoundingBoxCacheFraction(1.0);
            }
            answer = preprocessor.postProcess((IRCFComputeDescriptor)core.apply(preprocessor.preProcess(input, this.lastAnomalyDescriptor, this.forest)), this.lastAnomalyDescriptor, this.forest);
        }
        finally {
            if (ifZero) {
                this.forest.setBoundingBoxCacheFraction(0.0);
            }
        }
        return (T)answer;
    }

    public AnomalyDescriptor process(double[] inputPoint, long timestamp) {
        return this.process(inputPoint, timestamp, null);
    }

    public AnomalyDescriptor process(double[] inputPoint, long timestamp, int[] missingValues) {
        AnomalyDescriptor description;
        Function<AnomalyDescriptor, AnomalyDescriptor> function = x -> this.predictorCorrector.detect((AnomalyDescriptor)x, this.lastAnomalyDescriptor, this.forest);
        AnomalyDescriptor initial = new AnomalyDescriptor(inputPoint, timestamp);
        if (missingValues != null) {
            CommonUtils.checkArgument((missingValues.length <= inputPoint.length ? 1 : 0) != 0, (String)" incorrect data");
            for (int i = 0; i < missingValues.length; ++i) {
                CommonUtils.checkArgument((missingValues[i] >= 0 && missingValues[i] < inputPoint.length ? 1 : 0) != 0, (String)" incorrect positions ");
            }
            initial.setMissingValues(missingValues);
        }
        if ((description = this.singleStepProcess(initial, this.preprocessor, function)).getAnomalyGrade() > 0.0) {
            this.lastAnomalyDescriptor = description.copyOf();
        }
        return description;
    }

    public RandomCutForest getForest() {
        return this.forest;
    }

    public BasicThresholder getThresholder() {
        return this.predictorCorrector.getThresholder();
    }

    public void setZfactor(double factor) {
        this.predictorCorrector.setZfactor(factor);
    }

    public void setLowerThreshold(double lower) {
        this.predictorCorrector.setLowerThreshold(lower);
    }

    public void setHorizon(double horizon) {
        this.predictorCorrector.setHorizon(horizon);
    }

    public void setInitialThreshold(double initial) {
        this.predictorCorrector.setInitialThreshold(initial);
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    @Generated
    public IRCFComputeDescriptor getLastAnomalyDescriptor() {
        return this.lastAnomalyDescriptor;
    }

    @Generated
    public ForestMode getForestMode() {
        return this.forestMode;
    }

    @Generated
    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    @Generated
    public PredictorCorrector getPredictorCorrector() {
        return this.predictorCorrector;
    }

    @Generated
    public IPreprocessor<AnomalyDescriptor> getPreprocessor() {
        return this.preprocessor;
    }

    @Generated
    public void setLastAnomalyDescriptor(IRCFComputeDescriptor lastAnomalyDescriptor) {
        this.lastAnomalyDescriptor = lastAnomalyDescriptor;
    }

    @Generated
    public void setForestMode(ForestMode forestMode) {
        this.forestMode = forestMode;
    }

    @Generated
    public void setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
    }

    @Generated
    public void setForest(RandomCutForest forest) {
        this.forest = forest;
    }

    @Generated
    public void setPredictorCorrector(PredictorCorrector predictorCorrector) {
        this.predictorCorrector = predictorCorrector;
    }

    @Generated
    public void setPreprocessor(IPreprocessor<AnomalyDescriptor> preprocessor) {
        this.preprocessor = preprocessor;
    }

    public static class Builder<T extends Builder<T>> {
        protected int dimensions;
        protected int sampleSize = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected Optional<Integer> startNormalization = Optional.empty();
        protected Optional<Integer> stopNormalization = Optional.empty();
        protected int numberOfTrees = 50;
        protected Optional<Double> timeDecay = Optional.empty();
        protected Optional<Double> horizon = Optional.empty();
        protected Optional<Double> lowerThreshold = Optional.empty();
        protected Optional<Double> weightTime = Optional.empty();
        protected Optional<Long> randomSeed = Optional.empty();
        protected boolean compact = true;
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected boolean parallelExecutionEnabled = false;
        protected Optional<Integer> threadPoolSize = Optional.empty();
        protected Precision precision = RandomCutForest.DEFAULT_PRECISION;
        protected double boundingBoxCacheFraction = 1.0;
        protected int shingleSize = 1;
        protected Optional<Boolean> internalShinglingEnabled = Optional.empty();
        protected double initialAcceptFraction = 1.0;
        protected double anomalyRate = 0.01;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected boolean normalizeTime = false;
        protected boolean normalizeValues = false;
        protected double[] fillValues = null;
        protected double[] weights = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected boolean adjustThreshold = false;

        void validate() {
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                if (this.internalShinglingEnabled.isPresent()) {
                    CommonUtils.checkArgument((this.shingleSize == 1 || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" shingle size has to be 1 or internal shingling must turned on");
                    CommonUtils.checkArgument((this.transformMethod == TransformMethod.NONE || this.internalShinglingEnabled.get() != false ? 1 : 0) != 0, (String)" internal shingling must turned on for transforms");
                } else {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            } else if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                CommonUtils.checkArgument((this.shingleSize > 1 ? 1 : 0) != 0, (String)"imputation with shingle size 1 is not meaningful");
                this.internalShinglingEnabled.ifPresent(x -> CommonUtils.checkArgument((boolean)x, (String)" input cannot be shingled (even if internal representation is different) "));
            } else {
                if (!this.internalShinglingEnabled.isPresent()) {
                    this.internalShinglingEnabled = Optional.of(false);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            }
        }

        public ThresholdedRandomCutForest build() {
            this.validate();
            return new ThresholdedRandomCutForest(this);
        }

        protected RandomCutForest buildForest() {
            RandomCutForest.Builder builder = new RandomCutForest.Builder().dimensions(this.dimensions).sampleSize(this.sampleSize).numberOfTrees(this.numberOfTrees).compact(this.compact).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled).centerOfMassEnabled(this.centerOfMassEnabled).parallelExecutionEnabled(this.parallelExecutionEnabled).precision(this.precision).boundingBoxCacheFraction(this.boundingBoxCacheFraction).shingleSize(this.shingleSize).internalShinglingEnabled(this.internalShinglingEnabled.get().booleanValue()).initialAcceptFraction(this.initialAcceptFraction);
            this.outputAfter.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).outputAfter(arg_0));
            this.timeDecay.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).timeDecay(arg_0));
            this.randomSeed.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).randomSeed(arg_0));
            this.threadPoolSize.ifPresent(arg_0 -> ((RandomCutForest.Builder)builder).threadPoolSize(arg_0));
            return builder.build();
        }

        public T dimensions(int dimensions) {
            this.dimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = Optional.of(startNormalization);
            return (T)this;
        }

        public T stopNormalization(int stopNormalization) {
            this.stopNormalization = Optional.of(stopNormalization);
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T compact(boolean compact) {
            this.compact = compact;
            return (T)this;
        }

        public T internalShinglingEnabled(boolean internalShinglingEnabled) {
            this.internalShinglingEnabled = Optional.of(internalShinglingEnabled);
            return (T)this;
        }

        public T precision(Precision precision) {
            this.precision = precision;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }

        public T anomalyRate(double anomalyRate) {
            this.anomalyRate = anomalyRate;
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T weights(double[] values) {
            this.weights = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T adjustThreshold(boolean adjustThreshold) {
            this.adjustThreshold = adjustThreshold;
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = Optional.of(value);
            return (T)this;
        }
    }
}

