/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.ad.transport.handler.ADSearchHandler;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchAnomalyResultTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    private final Logger logger = LogManager.getLogger(SearchAnomalyResultTransportAction.class);
    private ADSearchHandler searchHandler;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;

    @Inject
    public SearchAnomalyResultTransportAction(TransportService transportService, ActionFilters actionFilters, ADSearchHandler searchHandler, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(SearchAnomalyResultAction.NAME, transportService, actionFilters, SearchRequest::new);
        this.searchHandler = searchHandler;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> listener) {
        String[] indices = request.indices();
        if (indices == null || indices.length == 0) {
            listener.onFailure((Exception)new IllegalArgumentException("No indices set in search request"));
            return;
        }
        boolean onlyQueryCustomResultIndex = true;
        for (String indexName : indices) {
            if (!".opendistro-anomaly-results*".equals(indexName)) continue;
            onlyQueryCustomResultIndex = false;
        }
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), indices);
        HashSet<String> customResultIndices = new HashSet<String>();
        if (concreteIndices != null) {
            for (String index : concreteIndices) {
                if (!index.startsWith("opensearch-ad-plugin-result-")) continue;
                customResultIndices.add(index);
            }
        }
        if (onlyQueryCustomResultIndex && customResultIndices.size() == 0) {
            listener.onFailure((Exception)new IllegalArgumentException("No custom result indices found"));
            return;
        }
        if (customResultIndices.size() > 0) {
            String resultIndexAggName = "result_index";
            SearchSourceBuilder searchResultIndexBuilder = new SearchSourceBuilder();
            TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)new TermsAggregationBuilder(resultIndexAggName).field("result_index")).size(10000);
            searchResultIndexBuilder.aggregation((AggregationBuilder)aggregation).size(0);
            SearchRequest searchResultIndex = new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchResultIndexBuilder);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                boolean finalOnlyQueryCustomResultIndex = onlyQueryCustomResultIndex;
                this.client.search(searchResultIndex, ActionListener.wrap(allResultIndicesResponse -> {
                    Aggregations aggregations = allResultIndicesResponse.getAggregations();
                    StringTerms resultIndicesAgg = (StringTerms)aggregations.get(resultIndexAggName);
                    List buckets = resultIndicesAgg.getBuckets();
                    HashSet resultIndicesOfDetector = new HashSet();
                    if (buckets == null) {
                        this.searchHandler.search(request, listener);
                        return;
                    }
                    buckets.stream().forEach(b -> resultIndicesOfDetector.add(b.getKeyAsString()));
                    ArrayList<String> targetIndices = new ArrayList<String>();
                    for (Object index : customResultIndices) {
                        if (!resultIndicesOfDetector.contains(index)) continue;
                        targetIndices.add((String)index);
                    }
                    if (targetIndices.size() == 0) {
                        this.searchHandler.search(request, listener);
                        return;
                    }
                    MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
                    for (String index : targetIndices) {
                        multiSearchRequest.add(new SearchRequest(new String[]{index}).source(new SearchSourceBuilder().query((QueryBuilder)new MatchAllQueryBuilder()).size(0)));
                    }
                    ArrayList<String> readableIndices = new ArrayList<String>();
                    if (!finalOnlyQueryCustomResultIndex) {
                        readableIndices.add(".opendistro-anomaly-results*");
                    }
                    context.restore();
                    this.client.multiSearch(multiSearchRequest, ActionListener.wrap(multiSearchResponse -> {
                        MultiSearchResponse.Item[] responses = multiSearchResponse.getResponses();
                        for (int i = 0; i < responses.length; ++i) {
                            MultiSearchResponse.Item item = responses[i];
                            String indexName = (String)targetIndices.get(i);
                            if (item.getFailure() != null) continue;
                            readableIndices.add(indexName);
                        }
                        if (readableIndices.size() == 0) {
                            listener.onFailure((Exception)new IllegalArgumentException("No readable custom result indices found"));
                            return;
                        }
                        request.indices(readableIndices.toArray(new String[0]));
                        this.searchHandler.search(request, listener);
                    }, multiSearchException -> {
                        this.logger.error("Failed to search custom AD result indices", (Throwable)multiSearchException);
                        listener.onFailure(multiSearchException);
                    }));
                }, e -> {
                    this.logger.error("Failed to search result indices for all detectors", (Throwable)e);
                    listener.onFailure(e);
                }));
            }
            catch (Exception e2) {
                this.logger.error((Object)e2);
                listener.onFailure(e2);
            }
        } else {
            request.indices(new String[]{".opendistro-anomaly-results*"});
            this.searchHandler.search(request, listener);
        }
    }
}

