/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class RCFPollingRequest
extends ActionRequest
implements ToXContentObject {
    private String adID;

    public RCFPollingRequest(StreamInput in) throws IOException {
        super(in);
        this.adID = in.readString();
    }

    public RCFPollingRequest(String adID) {
        this.adID = adID;
    }

    public String getAdID() {
        return this.adID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.adID);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.adID)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("adID", this.adID);
        builder.endObject();
        return builder;
    }
}

