/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public abstract class AbstractSetting {
    private static Logger logger = LogManager.getLogger(AbstractSetting.class);
    private ClusterService clusterService;
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();
    private final Map<String, Setting<?>> settings;

    protected AbstractSetting(Map<String, Setting<?>> settings) {
        this.settings = settings;
    }

    private void setSettingsUpdateConsumers() {
        for (Setting<?> setting : this.settings.values()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                logger.info("[AD] The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                this.latestSettings.put(setting.getKey(), newVal);
            });
        }
    }

    public void init(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.setSettingsUpdateConsumers();
    }

    public <T> T getSettingValue(String key) {
        return (T)this.latestSettings.getOrDefault(key, this.getSetting(key).getDefault(Settings.EMPTY));
    }

    private Setting<?> getSetting(String key) {
        if (this.settings.containsKey(key)) {
            return this.settings.get(key);
        }
        throw new IllegalArgumentException("Cannot find setting by key [" + key + "]");
    }

    public List<Setting<?>> getSettings() {
        return new ArrayList(this.settings.values());
    }
}

