/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.settings.EnabledSetting;
import org.opensearch.ad.transport.DeleteAnomalyResultsAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.builder.SearchSourceBuilder;

public class RestDeleteAnomalyResultsAction
extends BaseRestHandler {
    private static final String DELETE_AD_RESULTS_ACTION = "delete_anomaly_results";
    private static final Logger logger = LogManager.getLogger(RestDeleteAnomalyResultsAction.class);

    public String getName() {
        return DELETE_AD_RESULTS_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!EnabledSetting.isADPluginEnabled()) {
            throw new IllegalStateException("AD plugin is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{".opendistro-anomaly-results*"}).setQuery(searchSourceBuilder.query()).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN_HIDDEN);
        return channel -> client.execute((ActionType)DeleteAnomalyResultsAction.INSTANCE, (ActionRequest)deleteRequest, ActionListener.wrap(r -> {
            XContentBuilder contentBuilder = r.toXContent(channel.newBuilder().startObject(), ToXContent.EMPTY_PARAMS);
            contentBuilder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, contentBuilder));
        }, e -> {
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
            }
            catch (IOException exception) {
                logger.error("Failed to send back delete anomaly result exception result", (Throwable)exception);
            }
        }));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_anomaly_detection/detectors/results"));
    }
}

