/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ratelimit.CheckpointReadWorker;
import org.opensearch.ad.ratelimit.EntityFeatureRequest;
import org.opensearch.ad.ratelimit.RateLimitedRequestWorker;
import org.opensearch.ad.ratelimit.RequestPriority;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;

public class ColdEntityWorker
extends RateLimitedRequestWorker<EntityFeatureRequest> {
    private static final Logger LOG = LogManager.getLogger(ColdEntityWorker.class);
    public static final String WORKER_NAME = "cold-entity";
    private volatile int batchSize;
    private final CheckpointReadWorker checkpointReadQueue;
    private boolean scheduled;
    private volatile int expectedExecutionTimeInSecsPerRequest;

    public ColdEntityWorker(long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, CheckpointReadWorker checkpointReadQueue, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(WORKER_NAME, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, stateTtl, nodeStateManager);
        this.batchSize = (Integer)AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_BATCH_SIZE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_BATCH_SIZE, it -> {
            this.batchSize = it;
        });
        this.checkpointReadQueue = checkpointReadQueue;
        this.scheduled = false;
        this.expectedExecutionTimeInSecsPerRequest = (Integer)AnomalyDetectorSettings.EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_SECS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_SECS, it -> {
            this.expectedExecutionTimeInSecsPerRequest = it;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullRequests() {
        int pulledRequestSize = 0;
        int filteredRequestSize = 0;
        try {
            List requests = this.getRequests(this.batchSize);
            if (requests == null || requests.isEmpty()) {
                return;
            }
            pulledRequestSize = requests.size();
            List filteredRequests = requests.stream().filter(request -> request.priority == RequestPriority.LOW).collect(Collectors.toList());
            if (!filteredRequests.isEmpty()) {
                this.checkpointReadQueue.putAll(filteredRequests);
                filteredRequestSize = filteredRequests.size();
            }
        }
        catch (Exception e) {
            LOG.error("Error enqueuing cold entity requests", (Throwable)e);
        }
        finally {
            if (pulledRequestSize < this.batchSize) {
                this.scheduled = false;
            } else {
                this.scheduled = true;
                if (filteredRequestSize == 0) {
                    this.pullRequests();
                } else {
                    this.schedulePulling(this.getScheduleDelay(filteredRequestSize));
                }
            }
        }
    }

    private synchronized void schedulePulling(TimeValue delay) {
        try {
            this.threadPool.schedule(this::pullRequests, delay, "ad-threadpool");
        }
        catch (Exception e) {
            LOG.error("Fail to schedule cold entity pulling", (Throwable)e);
        }
    }

    @Override
    protected void triggerProcess() {
        if (!this.scheduled) {
            this.pullRequests();
        }
    }

    private TimeValue getScheduleDelay(int requestSize) {
        int expectedSingleRequestExecutionMillis = 1000 * this.expectedExecutionTimeInSecsPerRequest;
        int waitMilliSeconds = requestSize * expectedSingleRequestExecutionMillis;
        return TimeValue.timeValueMillis((long)(waitMilliSeconds + this.random.nextInt(waitMilliSeconds)));
    }
}

