/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestMapper;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.serialize.json.v1.V1JsonToV2StateConverter;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import java.io.IOException;
import java.security.AccessController;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetAction;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.ml.EntityModel;
import org.opensearch.ad.ml.ModelState;
import org.opensearch.ad.ml.SingleStreamModelIdMapper;
import org.opensearch.ad.ml.ThresholdingModel;
import org.opensearch.ad.model.Entity;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.client.Client;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ScrollableHitSource;

public class CheckpointDao {
    private static final Logger logger = LogManager.getLogger(CheckpointDao.class);
    static final String TIMEOUT_LOG_MSG = "Timeout while deleting checkpoints of";
    static final String BULK_FAILURE_LOG_MSG = "Bulk failure while deleting checkpoints of";
    static final String SEARCH_FAILURE_LOG_MSG = "Search failure while deleting checkpoints of";
    static final String DOC_GOT_DELETED_LOG_MSG = "checkpoints docs get deleted";
    static final String INDEX_DELETED_LOG_MSG = "Checkpoint index has been deleted.  Has nothing to do:";
    static final String NOT_ABLE_TO_DELETE_LOG_MSG = "Cannot delete all checkpoints of detector";
    public static final String ENTITY_SAMPLE = "sp";
    public static final String ENTITY_RCF = "rcf";
    public static final String ENTITY_THRESHOLD = "th";
    public static final String ENTITY_TRCF = "trcf";
    public static final String FIELD_MODEL = "model";
    public static final String FIELD_MODELV2 = "modelV2";
    public static final String TIMESTAMP = "timestamp";
    public static final String DETECTOR_ID = "detectorId";
    private final Client client;
    private final ClientUtil clientUtil;
    private final String indexName;
    private Gson gson;
    private RandomCutForestMapper mapper;
    private V1JsonToV2StateConverter converter;
    private ThresholdedRandomCutForestMapper trcfMapper;
    private Schema<ThresholdedRandomCutForestState> trcfSchema;
    private final Class<? extends ThresholdingModel> thresholdingModelClass;
    private final AnomalyDetectionIndices indexUtil;
    private final JsonParser parser = new JsonParser();
    private final int maxCheckpointBytes;
    private final GenericObjectPool<LinkedBuffer> serializeRCFBufferPool;
    private final int serializeRCFBufferSize;
    private double anomalyRate;

    public CheckpointDao(Client client, ClientUtil clientUtil, String indexName, Gson gson, RandomCutForestMapper mapper, V1JsonToV2StateConverter converter, ThresholdedRandomCutForestMapper trcfMapper, Schema<ThresholdedRandomCutForestState> trcfSchema, Class<? extends ThresholdingModel> thresholdingModelClass, AnomalyDetectionIndices indexUtil, int maxCheckpointBytes, GenericObjectPool<LinkedBuffer> serializeRCFBufferPool, int serializeRCFBufferSize, double anomalyRate) {
        this.client = client;
        this.clientUtil = clientUtil;
        this.indexName = indexName;
        this.gson = gson;
        this.mapper = mapper;
        this.converter = converter;
        this.trcfMapper = trcfMapper;
        this.trcfSchema = trcfSchema;
        this.thresholdingModelClass = thresholdingModelClass;
        this.indexUtil = indexUtil;
        this.maxCheckpointBytes = maxCheckpointBytes;
        this.serializeRCFBufferPool = serializeRCFBufferPool;
        this.serializeRCFBufferSize = serializeRCFBufferSize;
        this.anomalyRate = anomalyRate;
    }

    private void saveModelCheckpointSync(Map<String, Object> source, String modelId) {
        this.clientUtil.timedRequest(new IndexRequest(this.indexName).id(modelId).source(source), logger, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
    }

    private void putModelCheckpoint(String modelId, Map<String, Object> source, ActionListener<Void> listener) {
        if (this.indexUtil.doesCheckpointIndexExist()) {
            this.saveModelCheckpointAsync(source, modelId, listener);
        } else {
            this.onCheckpointNotExist(source, modelId, true, listener);
        }
    }

    public void putTRCFCheckpoint(String modelId, ThresholdedRandomCutForest forest, ActionListener<Void> listener) {
        HashMap<String, Object> source = new HashMap<String, Object>();
        String modelCheckpoint = this.toCheckpoint(forest);
        if (modelCheckpoint != null) {
            source.put(FIELD_MODELV2, modelCheckpoint);
            source.put(TIMESTAMP, ZonedDateTime.now(ZoneOffset.UTC));
            this.putModelCheckpoint(modelId, source, listener);
        } else {
            listener.onFailure((Exception)new RuntimeException("Fail to create checkpoint to save"));
        }
    }

    public void putThresholdCheckpoint(String modelId, ThresholdingModel threshold, ActionListener<Void> listener) {
        String modelCheckpoint = AccessController.doPrivileged(() -> this.gson.toJson((Object)threshold));
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put(FIELD_MODEL, modelCheckpoint);
        source.put(TIMESTAMP, ZonedDateTime.now(ZoneOffset.UTC));
        this.putModelCheckpoint(modelId, source, listener);
    }

    private void onCheckpointNotExist(Map<String, Object> source, String modelId, boolean isAsync, ActionListener<Void> listener) {
        this.indexUtil.initCheckpointIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> {
            if (initResponse.isAcknowledged()) {
                if (isAsync) {
                    this.saveModelCheckpointAsync(source, modelId, listener);
                } else {
                    this.saveModelCheckpointSync(source, modelId);
                }
            } else {
                throw new RuntimeException("Creating checkpoint with mappings call not acknowledged.");
            }
        }, exception -> {
            if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                if (isAsync) {
                    this.saveModelCheckpointAsync(source, modelId, listener);
                } else {
                    this.saveModelCheckpointSync(source, modelId);
                }
            } else {
                logger.error(String.format(Locale.ROOT, "Unexpected error creating index %s", this.indexName), (Throwable)exception);
            }
        }));
    }

    private void saveModelCheckpointAsync(Map<String, Object> source, String modelId, ActionListener<Void> listener) {
        UpdateRequest updateRequest = new UpdateRequest(this.indexName, modelId);
        updateRequest.doc(source);
        updateRequest.docAsUpsert(true);
        this.clientUtil.asyncRequest(updateRequest, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1), ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    public Map<String, Object> toIndexSource(ModelState<EntityModel> modelState) throws IOException {
        HashMap<String, Object> source = new HashMap<String, Object>();
        EntityModel model = modelState.getModel();
        Optional<String> serializedModel = this.toCheckpoint(model, modelState.getModelId());
        if (!serializedModel.isPresent() || serializedModel.get().length() > this.maxCheckpointBytes) {
            logger.warn((Message)new ParameterizedMessage("[{}]'s model is empty or too large: [{}] bytes", (Object)modelState.getModelId(), (Object)(serializedModel.isPresent() ? serializedModel.get().length() : 0)));
            return source;
        }
        String detectorId = modelState.getDetectorId();
        source.put(DETECTOR_ID, detectorId);
        source.put(FIELD_MODELV2, serializedModel.get());
        source.put(TIMESTAMP, ZonedDateTime.now(ZoneOffset.UTC));
        source.put("schema_version", this.indexUtil.getSchemaVersion(ADIndex.CHECKPOINT));
        Optional<Entity> entity = model.getEntity();
        if (entity.isPresent()) {
            source.put("entity", entity.get());
        }
        return source;
    }

    public Optional<String> toCheckpoint(EntityModel model, String modelId) {
        return AccessController.doPrivileged(() -> {
            if (model == null) {
                logger.warn("Empty model");
                return Optional.empty();
            }
            try {
                JsonObject json = new JsonObject();
                if (model.getSamples() != null && !model.getSamples().isEmpty()) {
                    json.add(ENTITY_SAMPLE, this.gson.toJsonTree(model.getSamples()));
                }
                if (model.getTrcf().isPresent()) {
                    json.addProperty(ENTITY_TRCF, this.toCheckpoint(model.getTrcf().get()));
                }
                return json.entrySet().isEmpty() ? Optional.empty() : Optional.ofNullable(this.gson.toJson((JsonElement)json));
            }
            catch (Exception ex) {
                logger.warn((Message)new ParameterizedMessage("fail to generate checkpoint for [{}]", (Object)modelId), (Throwable)ex);
                return Optional.empty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toCheckpoint(ThresholdedRandomCutForest trcf) {
        String checkpoint;
        block16: {
            checkpoint = null;
            Map.Entry<LinkedBuffer, Boolean> result = this.checkoutOrNewBuffer();
            LinkedBuffer buffer = result.getKey();
            boolean needCheckin = result.getValue();
            try {
                checkpoint = this.toCheckpoint(trcf, buffer);
            }
            catch (Exception e) {
                logger.error("Failed to serialize model", (Throwable)e);
                if (!needCheckin) break block16;
                try {
                    this.serializeRCFBufferPool.invalidateObject((Object)buffer);
                    needCheckin = false;
                }
                catch (Exception x) {
                    logger.warn("Failed to invalidate buffer", (Throwable)x);
                }
                try {
                    checkpoint = this.toCheckpoint(trcf, LinkedBuffer.allocate((int)this.serializeRCFBufferSize));
                }
                catch (Exception ex) {
                    logger.warn("Failed to generate checkpoint", (Throwable)ex);
                }
            }
            finally {
                if (needCheckin) {
                    try {
                        this.serializeRCFBufferPool.returnObject((Object)buffer);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to return buffer to pool", (Throwable)e);
                    }
                }
            }
        }
        return checkpoint;
    }

    private Map.Entry<LinkedBuffer, Boolean> checkoutOrNewBuffer() {
        LinkedBuffer buffer = null;
        boolean isCheckout = true;
        try {
            buffer = (LinkedBuffer)this.serializeRCFBufferPool.borrowObject();
        }
        catch (Exception e) {
            logger.warn("Failed to borrow a buffer from pool", (Throwable)e);
        }
        if (buffer == null) {
            buffer = LinkedBuffer.allocate((int)this.serializeRCFBufferSize);
            isCheckout = false;
        }
        return new AbstractMap.SimpleImmutableEntry<LinkedBuffer, Boolean>(buffer, isCheckout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toCheckpoint(ThresholdedRandomCutForest trcf, LinkedBuffer buffer) {
        try {
            byte[] bytes = AccessController.doPrivileged(() -> {
                ThresholdedRandomCutForestState trcfState = this.trcfMapper.toState(trcf);
                return ProtostuffIOUtil.toByteArray((Object)trcfState, this.trcfSchema, (LinkedBuffer)buffer);
            });
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
        finally {
            buffer.clear();
        }
    }

    public void deleteModelCheckpoint(String modelId, ActionListener<Void> listener) {
        this.clientUtil.asyncRequest(new DeleteRequest(this.indexName, modelId), (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1), ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteModelCheckpointByDetectorId(String detectorID) {
        DeleteByQueryRequest deleteRequest = (DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{".opendistro-anomaly-checkpoints"}).setQuery((QueryBuilder)new MatchQueryBuilder(DETECTOR_ID, (Object)detectorID)).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN).setAbortOnVersionConflict(false)).setRequestsPerSecond(500.0f);
        logger.info("Delete checkpoints of detector {}", (Object)detectorID);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteRequest, ActionListener.wrap(response -> {
            if (response.isTimedOut() || !response.getBulkFailures().isEmpty() || !response.getSearchFailures().isEmpty()) {
                this.logFailure((BulkByScrollResponse)response, detectorID);
            }
            logger.info("{} checkpoints docs get deleted", (Object)response.getDeleted());
        }, exception -> {
            if (exception instanceof IndexNotFoundException) {
                logger.info("Checkpoint index has been deleted.  Has nothing to do: {}", (Object)detectorID);
            } else {
                logger.error(NOT_ABLE_TO_DELETE_LOG_MSG, (Throwable)exception);
            }
        }));
    }

    private void logFailure(BulkByScrollResponse response, String detectorID) {
        if (response.isTimedOut()) {
            logger.warn("Timeout while deleting checkpoints of {}", (Object)detectorID);
        } else if (!response.getBulkFailures().isEmpty()) {
            logger.warn("Bulk failure while deleting checkpoints of {}", (Object)detectorID);
            for (BulkItemResponse.Failure bulkFailure : response.getBulkFailures()) {
                logger.warn((Object)bulkFailure);
            }
        } else {
            logger.warn("Search failure while deleting checkpoints of {}", (Object)detectorID);
            for (ScrollableHitSource.SearchFailure searchFailure : response.getSearchFailures()) {
                logger.warn((Object)searchFailure);
            }
        }
    }

    public Optional<Map.Entry<EntityModel, Instant>> fromEntityModelCheckpoint(Map<String, Object> checkpoint, String modelId) {
        try {
            return AccessController.doPrivileged(() -> {
                Object modelObj = checkpoint.get(FIELD_MODELV2);
                if (modelObj == null) {
                    modelObj = checkpoint.get(FIELD_MODEL);
                }
                if (modelObj == null) {
                    logger.warn((Message)new ParameterizedMessage("Empty model for [{}]", (Object)modelId));
                    return Optional.empty();
                }
                String model = (String)modelObj;
                if (model.length() > this.maxCheckpointBytes) {
                    logger.warn((Message)new ParameterizedMessage("[{}]'s model too large: [{}] bytes", (Object)modelId, (Object)model.length()));
                    return Optional.empty();
                }
                JsonObject json = this.parser.parse(model).getAsJsonObject();
                ArrayDeque<Object> samples = null;
                samples = json.has(ENTITY_SAMPLE) ? new ArrayDeque(Arrays.asList((double[][])this.gson.fromJson((JsonElement)json.getAsJsonArray(ENTITY_SAMPLE), new double[0][0].getClass()))) : new ArrayDeque();
                ThresholdedRandomCutForest trcf = null;
                if (json.has(ENTITY_TRCF)) {
                    trcf = this.toTrcf(json.getAsJsonPrimitive(ENTITY_TRCF).getAsString());
                } else {
                    Optional<ThresholdedRandomCutForest> convertedTRCF;
                    Optional<RandomCutForest> rcf = Optional.empty();
                    Optional<ThresholdingModel> threshold = Optional.empty();
                    if (json.has(ENTITY_RCF)) {
                        String serializedRCF = json.getAsJsonPrimitive(ENTITY_RCF).getAsString();
                        rcf = this.deserializeRCFModel(serializedRCF, modelId);
                    }
                    if (json.has(ENTITY_THRESHOLD)) {
                        threshold = Optional.ofNullable((ThresholdingModel)this.gson.fromJson(json.getAsJsonPrimitive(ENTITY_THRESHOLD).getAsString(), this.thresholdingModelClass));
                    }
                    if ((convertedTRCF = this.convertToTRCF(rcf, threshold)).isPresent()) {
                        trcf = convertedTRCF.get();
                    }
                }
                String lastCheckpointTimeString = (String)checkpoint.get(TIMESTAMP);
                Instant timestamp = Instant.parse(lastCheckpointTimeString);
                Entity entity = null;
                Object serializedEntity = checkpoint.get("entity");
                if (serializedEntity != null) {
                    try {
                        entity = Entity.fromJsonArray(serializedEntity);
                    }
                    catch (Exception e) {
                        logger.error((Message)new ParameterizedMessage("fail to parse entity", serializedEntity), (Throwable)e);
                    }
                }
                EntityModel entityModel = new EntityModel(entity, samples, trcf);
                return Optional.of(new AbstractMap.SimpleImmutableEntry<EntityModel, Instant>(entityModel, timestamp));
            });
        }
        catch (Exception e) {
            logger.warn("Exception while deserializing checkpoint " + modelId, (Throwable)e);
            return Optional.empty();
        }
    }

    private ThresholdedRandomCutForest toTrcf(String checkpoint) {
        ThresholdedRandomCutForest trcf = null;
        if (checkpoint != null && !checkpoint.isEmpty()) {
            try {
                byte[] bytes = Base64.getDecoder().decode(checkpoint);
                ThresholdedRandomCutForestState state = (ThresholdedRandomCutForestState)this.trcfSchema.newMessage();
                AccessController.doPrivileged(() -> {
                    ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)state, this.trcfSchema);
                    return null;
                });
                trcf = (ThresholdedRandomCutForest)this.trcfMapper.toModel((Object)state);
            }
            catch (RuntimeException e) {
                logger.error("Failed to deserialize TRCF model", (Throwable)e);
            }
        }
        return trcf;
    }

    private Optional<RandomCutForest> deserializeRCFModel(String checkpoint, String modelId) {
        if (checkpoint == null || checkpoint.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(AccessController.doPrivileged(() -> {
            try {
                RandomCutForestState state = this.converter.convert(checkpoint, Precision.FLOAT_32);
                return this.mapper.toModel(state);
            }
            catch (Exception e) {
                logger.error("Unexpected error when deserializing " + modelId, (Throwable)e);
                return null;
            }
        }));
    }

    private void deserializeTRCFModel(GetResponse response, String rcfModelId, ActionListener<Optional<ThresholdedRandomCutForest>> listener) {
        block6: {
            Object model = null;
            if (response.isExists()) {
                try {
                    model = response.getSource().get(FIELD_MODELV2);
                    if (model != null) {
                        listener.onResponse(Optional.ofNullable(this.toTrcf(model)));
                        break block6;
                    }
                    Object modelV1 = response.getSource().get(FIELD_MODEL);
                    Optional<RandomCutForest> forest = this.deserializeRCFModel((String)modelV1, rcfModelId);
                    if (!forest.isPresent()) {
                        logger.error("Unexpected error when deserializing [{}]", (Object)rcfModelId);
                        listener.onResponse(Optional.empty());
                        return;
                    }
                    String thresholdingModelId = SingleStreamModelIdMapper.getThresholdModelIdFromRCFModelId(rcfModelId);
                    this.getThresholdModel(thresholdingModelId, (ActionListener<Optional<ThresholdingModel>>)ActionListener.wrap(thresholdingModel -> listener.onResponse(this.convertToTRCF(forest, (Optional<ThresholdingModel>)thresholdingModel)), arg_0 -> listener.onFailure(arg_0)));
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("Unexpected error when deserializing [{}]", (Object)rcfModelId), (Throwable)e);
                    listener.onResponse(Optional.empty());
                }
            } else {
                listener.onResponse(Optional.empty());
            }
        }
    }

    public void deserializeModelCheckpoint(String modelId, ActionListener<Optional<Map.Entry<EntityModel, Instant>>> listener) {
        this.clientUtil.asyncRequest(new GetRequest(this.indexName, modelId), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), ActionListener.wrap(response -> listener.onResponse(this.processGetResponse((GetResponse)response, modelId)), arg_0 -> listener.onFailure(arg_0)));
    }

    public Optional<Map.Entry<EntityModel, Instant>> processGetResponse(GetResponse response, String modelId) {
        Optional<Map<String, Object>> checkpointString = this.processRawCheckpoint(response);
        if (checkpointString.isPresent()) {
            return this.fromEntityModelCheckpoint(checkpointString.get(), modelId);
        }
        return Optional.empty();
    }

    public void getTRCFModel(String modelId, ActionListener<Optional<ThresholdedRandomCutForest>> listener) {
        this.clientUtil.asyncRequest(new GetRequest(this.indexName, modelId), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), ActionListener.wrap(response -> this.deserializeTRCFModel((GetResponse)response, modelId, listener), exception -> {
            if (exception instanceof IndexNotFoundException) {
                listener.onResponse(Optional.empty());
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    public void getThresholdModel(String modelId, ActionListener<Optional<ThresholdingModel>> listener) {
        this.clientUtil.asyncRequest(new GetRequest(this.indexName, modelId), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1), ActionListener.wrap(response -> {
            Optional<Object> thresholdCheckpoint = this.processThresholdModelCheckpoint((GetResponse)response);
            if (!thresholdCheckpoint.isPresent()) {
                listener.onFailure((Exception)new ResourceNotFoundException("", "Fail to find model " + modelId));
                return;
            }
            Optional<ThresholdingModel> model = thresholdCheckpoint.map(checkpoint -> AccessController.doPrivileged(() -> (ThresholdingModel)this.gson.fromJson((String)checkpoint, this.thresholdingModelClass)));
            listener.onResponse(model);
        }, exception -> {
            if (exception instanceof IndexNotFoundException) {
                listener.onResponse(Optional.empty());
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    private Optional<Object> processThresholdModelCheckpoint(GetResponse response) {
        return Optional.ofNullable(response).filter(GetResponse::isExists).map(GetResponse::getSource).map(source -> source.get(FIELD_MODEL));
    }

    private Optional<Map<String, Object>> processRawCheckpoint(GetResponse response) {
        return Optional.ofNullable(response).filter(GetResponse::isExists).map(GetResponse::getSource);
    }

    public void batchRead(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.clientUtil.execute(MultiGetAction.INSTANCE, request, listener);
    }

    public void batchWrite(BulkRequest request, ActionListener<BulkResponse> listener) {
        if (this.indexUtil.doesCheckpointIndexExist()) {
            this.clientUtil.execute(BulkAction.INSTANCE, request, listener);
        } else {
            this.indexUtil.initCheckpointIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> {
                if (initResponse.isAcknowledged()) {
                    this.clientUtil.execute(BulkAction.INSTANCE, request, listener);
                } else {
                    listener.onFailure((Exception)new AnomalyDetectionException("Creating checkpoint with mappings call not acknowledged."));
                }
            }, exception -> {
                if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                    this.clientUtil.execute(BulkAction.INSTANCE, request, listener);
                } else {
                    logger.error(String.format(Locale.ROOT, "Unexpected error creating checkpoint index", new Object[0]), (Throwable)exception);
                    listener.onFailure(exception);
                }
            }));
        }
    }

    private Optional<ThresholdedRandomCutForest> convertToTRCF(Optional<RandomCutForest> rcf, Optional<ThresholdingModel> kllThreshold) {
        if (!rcf.isPresent()) {
            return Optional.empty();
        }
        List<Object> scores = new ArrayList();
        if (kllThreshold.isPresent()) {
            scores = kllThreshold.get().extractScores();
        }
        return Optional.of(new ThresholdedRandomCutForest(rcf.get(), this.anomalyRate, scores));
    }
}

