/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.common.exception;

import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.model.DetectorValidationIssueType;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.model.ValidationAspect;

public class ADValidationException
extends AnomalyDetectionException {
    private final DetectorValidationIssueType type;
    private final ValidationAspect aspect;
    private final IntervalTimeConfiguration intervalSuggestion;

    public DetectorValidationIssueType getType() {
        return this.type;
    }

    public ValidationAspect getAspect() {
        return this.aspect;
    }

    public IntervalTimeConfiguration getIntervalSuggestion() {
        return this.intervalSuggestion;
    }

    public ADValidationException(String message, DetectorValidationIssueType type, ValidationAspect aspect) {
        this(message, null, type, aspect, null);
    }

    public ADValidationException(String message, DetectorValidationIssueType type, ValidationAspect aspect, IntervalTimeConfiguration intervalSuggestion) {
        this(message, null, type, aspect, intervalSuggestion);
    }

    public ADValidationException(String message, Throwable cause, DetectorValidationIssueType type, ValidationAspect aspect, IntervalTimeConfiguration intervalSuggestion) {
        super("", message, cause);
        this.type = type;
        this.aspect = aspect;
        this.intervalSuggestion = intervalSuggestion;
    }

    @Override
    public String toString() {
        String superString = super.toString();
        StringBuilder sb = new StringBuilder(superString);
        if (this.type != null) {
            sb.append(" type: ");
            sb.append(this.type.getName());
        }
        if (this.aspect != null) {
            sb.append(" aspect: ");
            sb.append(this.aspect.getName());
        }
        if (this.intervalSuggestion != null) {
            sb.append(" interval suggestion: ");
            sb.append(this.intervalSuggestion.getInterval());
            sb.append(this.intervalSuggestion.getUnit());
        }
        return sb.toString();
    }
}

