/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import org.opensearch.ad.cluster.HourlyCron;
import org.opensearch.ad.cluster.diskcleanup.IndexCleanup;
import org.opensearch.ad.cluster.diskcleanup.ModelCheckpointIndexRetention;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeMasterListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.component.LifecycleListener;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class MasterEventListener
implements LocalNodeMasterListener {
    private Scheduler.Cancellable checkpointIndexRetentionCron;
    private Scheduler.Cancellable hourlyCron;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private Clock clock;
    private ClientUtil clientUtil;
    private DiscoveryNodeFilterer nodeFilter;

    public MasterEventListener(ClusterService clusterService, ThreadPool threadPool, Client client, Clock clock, ClientUtil clientUtil, DiscoveryNodeFilterer nodeFilter) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        this.clock = clock;
        this.clientUtil = clientUtil;
        this.nodeFilter = nodeFilter;
    }

    public void onMaster() {
        if (this.hourlyCron == null) {
            this.hourlyCron = this.threadPool.scheduleWithFixedDelay((Runnable)new HourlyCron(this.client, this.nodeFilter), TimeValue.timeValueHours((long)1L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    MasterEventListener.this.cancel(MasterEventListener.this.hourlyCron);
                    MasterEventListener.this.hourlyCron = null;
                }
            });
        }
        if (this.checkpointIndexRetentionCron == null) {
            IndexCleanup indexCleanup = new IndexCleanup(this.client, this.clientUtil, this.clusterService);
            this.checkpointIndexRetentionCron = this.threadPool.scheduleWithFixedDelay((Runnable)new ModelCheckpointIndexRetention(AnomalyDetectorSettings.CHECKPOINT_TTL, this.clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    MasterEventListener.this.cancel(MasterEventListener.this.checkpointIndexRetentionCron);
                    MasterEventListener.this.checkpointIndexRetentionCron = null;
                }
            });
        }
    }

    public void offMaster() {
        this.cancel(this.hourlyCron);
        this.cancel(this.checkpointIndexRetentionCron);
        this.hourlyCron = null;
        this.checkpointIndexRetentionCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }

    @VisibleForTesting
    protected Scheduler.Cancellable getCheckpointIndexRetentionCron() {
        return this.checkpointIndexRetentionCron;
    }

    protected Scheduler.Cancellable getHourlyCron() {
        return this.hourlyCron;
    }

    private String executorName() {
        return "generic";
    }
}

