/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.caching;

import com.google.common.base.Charsets;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.opensearch.ad.ExpiringState;
import org.opensearch.ad.MaintenanceState;

public class DoorKeeper
implements MaintenanceState,
ExpiringState {
    private BloomFilter<String> bloomFilter;
    private final long expectedInsertions;
    private final double fpp;
    private Instant lastMaintenanceTime;
    private final Duration resetInterval;
    private final Clock clock;
    private Instant lastAccessTime;

    public DoorKeeper(long expectedInsertions, double fpp, Duration resetInterval, Clock clock) {
        this.expectedInsertions = expectedInsertions;
        this.fpp = fpp;
        this.resetInterval = resetInterval;
        this.clock = clock;
        this.lastAccessTime = clock.instant();
        this.maintenance();
    }

    public boolean mightContain(String modelId) {
        this.lastAccessTime = this.clock.instant();
        return this.bloomFilter.mightContain((Object)modelId);
    }

    public boolean put(String modelId) {
        this.lastAccessTime = this.clock.instant();
        return this.bloomFilter.put((Object)modelId);
    }

    @Override
    public void maintenance() {
        if (this.bloomFilter == null || this.lastMaintenanceTime.plus(this.resetInterval).isBefore(this.clock.instant())) {
            this.bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.US_ASCII), (long)this.expectedInsertions, (double)this.fpp);
            this.lastMaintenanceTime = this.clock.instant();
        }
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastAccessTime, this.resetInterval, this.clock.instant());
    }
}

