/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.LuceneQuery;

public class MatchQuery
extends LuceneQuery {
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> analyzer = (b, v) -> b.analyzer(v.stringValue());
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> synonymsPhrase = (b, v) -> b.autoGenerateSynonymsPhraseQuery(Boolean.parseBoolean(v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> fuzziness = (b, v) -> b.fuzziness((Object)v.stringValue());
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> maxExpansions = (b, v) -> b.maxExpansions(Integer.parseInt(v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> prefixLength = (b, v) -> b.prefixLength(Integer.parseInt(v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> fuzzyTranspositions = (b, v) -> b.fuzzyTranspositions(Boolean.parseBoolean(v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> fuzzyRewrite = (b, v) -> b.fuzzyRewrite(v.stringValue());
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> lenient = (b, v) -> b.lenient(Boolean.parseBoolean(v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> operator = (b, v) -> b.operator(Operator.fromString((String)v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> minimumShouldMatch = (b, v) -> b.minimumShouldMatch(v.stringValue());
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> zeroTermsQuery = (b, v) -> b.zeroTermsQuery(MatchQuery.ZeroTermsQuery.valueOf((String)v.stringValue()));
    private final BiFunction<MatchQueryBuilder, ExprValue, MatchQueryBuilder> boost = (b, v) -> (MatchQueryBuilder)b.boost(Float.parseFloat(v.stringValue()));
    ImmutableMap<Object, Object> argAction = ImmutableMap.builder().put((Object)"analyzer", this.analyzer).put((Object)"auto_generate_synonyms_phrase_query", this.synonymsPhrase).put((Object)"fuzziness", this.fuzziness).put((Object)"max_expansions", this.maxExpansions).put((Object)"prefix_length", this.prefixLength).put((Object)"fuzzy_transpositions", this.fuzzyTranspositions).put((Object)"fuzzy_rewrite", this.fuzzyRewrite).put((Object)"lenient", this.lenient).put((Object)"operator", this.operator).put((Object)"minimum_should_match", this.minimumShouldMatch).put((Object)"zero_terms_query", this.zeroTermsQuery).put((Object)"boost", this.boost).build();

    @Override
    public QueryBuilder build(FunctionExpression func) {
        Iterator iterator = func.getArguments().iterator();
        NamedArgumentExpression field = (NamedArgumentExpression)iterator.next();
        NamedArgumentExpression query = (NamedArgumentExpression)iterator.next();
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)field.getValue().valueOf(null).stringValue(), (Object)query.getValue().valueOf(null).stringValue());
        while (iterator.hasNext()) {
            NamedArgumentExpression arg = (NamedArgumentExpression)iterator.next();
            if (!this.argAction.containsKey((Object)arg.getArgName())) {
                throw new SemanticCheckException(String.format("Parameter %s is invalid for match function.", arg.getArgName()));
            }
            ((BiFunction)this.argAction.get((Object)arg.getArgName())).apply(queryBuilder, arg.getValue().valueOf(null));
        }
        return queryBuilder;
    }
}

