/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchQueryRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchIndexScan
extends TableScanOperator {
    private final OpenSearchClient client;
    private final OpenSearchRequest request;
    private Iterator<ExprValue> iterator;

    public OpenSearchIndexScan(OpenSearchClient client, Settings settings, String indexName, OpenSearchExprValueFactory exprValueFactory) {
        this(client, settings, new OpenSearchRequest.IndexName(indexName), exprValueFactory);
    }

    public OpenSearchIndexScan(OpenSearchClient client, Settings settings, OpenSearchRequest.IndexName indexName, OpenSearchExprValueFactory exprValueFactory) {
        this.client = client;
        this.request = new OpenSearchQueryRequest(indexName, (int)((Integer)settings.getSettingValue(Settings.Key.QUERY_SIZE_LIMIT)), exprValueFactory);
    }

    public void open() {
        super.open();
        ArrayList<OpenSearchResponse> responses = new ArrayList<OpenSearchResponse>();
        OpenSearchResponse response = this.client.search(this.request);
        while (!response.isEmpty()) {
            responses.add(response);
            response = this.client.search(this.request);
        }
        this.iterator = Iterables.concat((Iterable[])responses.toArray(new OpenSearchResponse[0])).iterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public ExprValue next() {
        return this.iterator.next();
    }

    public void pushDown(QueryBuilder query) {
        SearchSourceBuilder source = this.request.getSourceBuilder();
        QueryBuilder current = source.query();
        if (current == null) {
            source.query(query);
        } else if (this.isBoolFilterQuery(current)) {
            ((BoolQueryBuilder)current).filter(query);
        } else {
            source.query((QueryBuilder)QueryBuilders.boolQuery().filter(current).filter(query));
        }
        if (source.sorts() == null) {
            source.sort("_doc", SortOrder.ASC);
        }
    }

    public void pushDownAggregation(Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> aggregationBuilder) {
        SearchSourceBuilder source = this.request.getSourceBuilder();
        ((List)aggregationBuilder.getLeft()).forEach(builder -> source.aggregation(builder));
        source.size(0);
        this.request.getExprValueFactory().setParser((OpenSearchAggregationResponseParser)aggregationBuilder.getRight());
    }

    public void pushDownSort(List<SortBuilder<?>> sortBuilders) {
        SearchSourceBuilder source = this.request.getSourceBuilder();
        for (SortBuilder<?> sortBuilder : sortBuilders) {
            source.sort(sortBuilder);
        }
    }

    public void pushDownLimit(Integer limit, Integer offset) {
        SearchSourceBuilder sourceBuilder = this.request.getSourceBuilder();
        sourceBuilder.from(offset.intValue()).size(limit.intValue());
    }

    public void pushDownProjects(Set<ReferenceExpression> projects) {
        SearchSourceBuilder sourceBuilder = this.request.getSourceBuilder();
        Set<String> projectsSet = projects.stream().map(ReferenceExpression::getAttr).collect(Collectors.toSet());
        sourceBuilder.fetchSource(projectsSet.toArray(new String[0]), new String[0]);
    }

    public void pushTypeMapping(Map<String, ExprType> typeMapping) {
        this.request.getExprValueFactory().setTypeMapping(typeMapping);
    }

    public void close() {
        super.close();
        this.client.cleanup(this.request);
    }

    private boolean isBoolFilterQuery(QueryBuilder current) {
        return current instanceof BoolQueryBuilder;
    }

    public String explain() {
        return this.getRequest().toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScan)) {
            return false;
        }
        OpenSearchIndexScan other = (OpenSearchIndexScan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        OpenSearchRequest this$request = this.getRequest();
        OpenSearchRequest other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OpenSearchRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchIndexScan(request=" + this.getRequest() + ")";
    }

    @Generated
    public OpenSearchRequest getRequest() {
        return this.request;
    }
}

