/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;

public class OpenSearchResponse
implements Iterable<ExprValue> {
    private final SearchHits hits;
    private final Aggregations aggregations;
    private final OpenSearchExprValueFactory exprValueFactory;

    public OpenSearchResponse(SearchResponse searchResponse, OpenSearchExprValueFactory exprValueFactory) {
        this.hits = searchResponse.getHits();
        this.aggregations = searchResponse.getAggregations();
        this.exprValueFactory = exprValueFactory;
    }

    public OpenSearchResponse(SearchHits hits, OpenSearchExprValueFactory exprValueFactory) {
        this.hits = hits;
        this.aggregations = null;
        this.exprValueFactory = exprValueFactory;
    }

    public boolean isEmpty() {
        return this.hits.getHits() == null || this.hits.getHits().length == 0 && this.aggregations == null;
    }

    public boolean isAggregationResponse() {
        return this.aggregations != null;
    }

    @Override
    public Iterator<ExprValue> iterator() {
        if (this.isAggregationResponse()) {
            return this.exprValueFactory.getParser().parse(this.aggregations).stream().map(entry -> {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                for (Map.Entry value : entry.entrySet()) {
                    builder.put((Object)((String)value.getKey()), (Object)this.exprValueFactory.construct((String)value.getKey(), value.getValue()));
                }
                return ExprTupleValue.fromExprValueMap((Map)builder.build());
            }).iterator();
        }
        return Arrays.stream(this.hits.getHits()).map(hit -> this.exprValueFactory.construct(hit.getSourceAsString())).iterator();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchResponse)) {
            return false;
        }
        OpenSearchResponse other = (OpenSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SearchHits this$hits = this.hits;
        SearchHits other$hits = other.hits;
        if (this$hits == null ? other$hits != null : !this$hits.equals(other$hits)) {
            return false;
        }
        Aggregations this$aggregations = this.aggregations;
        Aggregations other$aggregations = other.aggregations;
        return !(this$aggregations == null ? other$aggregations != null : !this$aggregations.equals(other$aggregations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SearchHits $hits = this.hits;
        result = result * 59 + ($hits == null ? 43 : $hits.hashCode());
        Aggregations $aggregations = this.aggregations;
        result = result * 59 + ($aggregations == null ? 43 : $aggregations.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchResponse(hits=" + this.hits + ", aggregations=" + this.aggregations + ", exprValueFactory=" + this.exprValueFactory + ")";
    }
}

