/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchScrollRequest
implements OpenSearchRequest {
    public static final TimeValue DEFAULT_SCROLL_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private final OpenSearchRequest.IndexName indexName;
    private final OpenSearchExprValueFactory exprValueFactory;
    private String scrollId;
    private final SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

    public OpenSearchScrollRequest(OpenSearchRequest.IndexName indexName, OpenSearchExprValueFactory exprValueFactory) {
        this.indexName = indexName;
        this.exprValueFactory = exprValueFactory;
    }

    public OpenSearchScrollRequest(String indexName, OpenSearchExprValueFactory exprValueFactory) {
        this(new OpenSearchRequest.IndexName(indexName), exprValueFactory);
    }

    @Override
    public OpenSearchResponse search(Function<SearchRequest, SearchResponse> searchAction, Function<SearchScrollRequest, SearchResponse> scrollAction) {
        SearchResponse openSearchResponse = this.isScrollStarted() ? scrollAction.apply(this.scrollRequest()) : searchAction.apply(this.searchRequest());
        this.setScrollId(openSearchResponse.getScrollId());
        return new OpenSearchResponse(openSearchResponse, this.exprValueFactory);
    }

    @Override
    public void clean(Consumer<String> cleanAction) {
        try {
            if (this.isScrollStarted()) {
                cleanAction.accept(this.getScrollId());
            }
        }
        finally {
            this.reset();
        }
    }

    public SearchRequest searchRequest() {
        return new SearchRequest().indices(this.indexName.getIndexNames()).scroll(DEFAULT_SCROLL_TIMEOUT).source(this.sourceBuilder);
    }

    public boolean isScrollStarted() {
        return this.scrollId != null;
    }

    public SearchScrollRequest scrollRequest() {
        Objects.requireNonNull(this.scrollId, "Scroll id cannot be null");
        return new SearchScrollRequest().scroll(DEFAULT_SCROLL_TIMEOUT).scrollId(this.scrollId);
    }

    public void reset() {
        this.scrollId = null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchScrollRequest)) {
            return false;
        }
        OpenSearchScrollRequest other = (OpenSearchScrollRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OpenSearchRequest.IndexName this$indexName = this.getIndexName();
        OpenSearchRequest.IndexName other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !((Object)this$indexName).equals(other$indexName)) {
            return false;
        }
        String this$scrollId = this.getScrollId();
        String other$scrollId = other.getScrollId();
        if (this$scrollId == null ? other$scrollId != null : !this$scrollId.equals(other$scrollId)) {
            return false;
        }
        SearchSourceBuilder this$sourceBuilder = this.getSourceBuilder();
        SearchSourceBuilder other$sourceBuilder = other.getSourceBuilder();
        return !(this$sourceBuilder == null ? other$sourceBuilder != null : !this$sourceBuilder.equals(other$sourceBuilder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchScrollRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OpenSearchRequest.IndexName $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : ((Object)$indexName).hashCode());
        String $scrollId = this.getScrollId();
        result = result * 59 + ($scrollId == null ? 43 : $scrollId.hashCode());
        SearchSourceBuilder $sourceBuilder = this.getSourceBuilder();
        result = result * 59 + ($sourceBuilder == null ? 43 : $sourceBuilder.hashCode());
        return result;
    }

    @Generated
    public OpenSearchRequest.IndexName getIndexName() {
        return this.indexName;
    }

    @Override
    @Generated
    public OpenSearchExprValueFactory getExprValueFactory() {
        return this.exprValueFactory;
    }

    @Generated
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    @Generated
    public SearchSourceBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    @Generated
    public String toString() {
        return "OpenSearchScrollRequest(indexName=" + this.getIndexName() + ", scrollId=" + this.getScrollId() + ", sourceBuilder=" + this.getSourceBuilder() + ")";
    }

    @Generated
    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }
}

