/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.logical.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.opensearch.planner.logical.OpenSearchLogicalIndexScan;
import org.opensearch.sql.opensearch.planner.logical.rule.OptimizationRuleUtils;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;

public class MergeSortAndIndexScan
implements Rule<LogicalSort> {
    private final Capture<OpenSearchLogicalIndexScan> indexScanCapture = Capture.newCapture();
    private final Pattern<LogicalSort> pattern = Pattern.typeOf(LogicalSort.class).matching(OptimizationRuleUtils::sortByFieldsOnly).with(Patterns.source().matching(Pattern.typeOf(OpenSearchLogicalIndexScan.class).capturedAs(this.indexScanCapture)));

    public Pattern<LogicalSort> pattern() {
        return this.pattern;
    }

    public LogicalPlan apply(LogicalSort sort, Captures captures) {
        OpenSearchLogicalIndexScan indexScan = (OpenSearchLogicalIndexScan)((Object)captures.get(this.indexScanCapture));
        return OpenSearchLogicalIndexScan.builder().relationName(indexScan.getRelationName()).filter(indexScan.getFilter()).sortList(this.mergeSortList(indexScan.getSortList(), sort.getSortList())).build();
    }

    private List<Pair<Sort.SortOption, Expression>> mergeSortList(List<Pair<Sort.SortOption, Expression>> l1, List<Pair<Sort.SortOption, Expression>> l2) {
        if (null == l1) {
            return l2;
        }
        return Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList());
    }
}

