/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;

public enum OpenSearchDataType implements ExprType
{
    OPENSEARCH_TEXT(Collections.singletonList(ExprCoreType.STRING), "string"){

        public boolean shouldCast(ExprType other) {
            return false;
        }
    }
    ,
    OPENSEARCH_TEXT_KEYWORD((List)Arrays.asList(new ExprType[]{ExprCoreType.STRING, OPENSEARCH_TEXT}), "string"){

        public boolean shouldCast(ExprType other) {
            return false;
        }
    }
    ,
    OPENSEARCH_IP(Arrays.asList(ExprCoreType.UNKNOWN), "ip"),
    OPENSEARCH_GEO_POINT(Arrays.asList(ExprCoreType.UNKNOWN), "geo_point"),
    OPENSEARCH_BINARY(Arrays.asList(ExprCoreType.UNKNOWN), "binary");

    private static final Map<ExprType, String> LEGACY_TYPE_NAME_MAPPING;
    private final List<ExprType> parents;
    private final String jdbcType;

    public List<ExprType> getParent() {
        return this.parents;
    }

    public String typeName() {
        return this.jdbcType;
    }

    public String legacyTypeName() {
        return LEGACY_TYPE_NAME_MAPPING.getOrDefault((Object)this, this.typeName());
    }

    @Generated
    private OpenSearchDataType(List<ExprType> parents, String jdbcType) {
        this.parents = parents;
        this.jdbcType = jdbcType;
    }

    static {
        LEGACY_TYPE_NAME_MAPPING = new ImmutableMap.Builder().put((Object)OPENSEARCH_TEXT, (Object)"text").put((Object)OPENSEARCH_TEXT_KEYWORD, (Object)"text").build();
    }
}

