/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import java.util.Base64;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.authuser.User;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.Model;

public class MLModel
implements ToXContentObject {
    public static final String ALGORITHM = "algorithm";
    public static final String MODEL_NAME = "name";
    public static final String MODEL_VERSION = "version";
    public static final String MODEL_CONTENT = "content";
    public static final String USER = "user";
    private String name;
    private FunctionName algorithm;
    private Integer version;
    private String content;
    private User user;

    public MLModel(String name, FunctionName algorithm, Integer version, String content, User user) {
        this.name = name;
        this.algorithm = algorithm;
        this.version = version;
        this.content = content;
        this.user = user;
    }

    public MLModel(FunctionName algorithm, Model model) {
        this(model.getName(), algorithm, model.getVersion(), Base64.getEncoder().encodeToString(model.getContent()), null);
    }

    public MLModel(StreamInput input) throws IOException {
        this.name = input.readOptionalString();
        this.algorithm = (FunctionName)input.readEnum(FunctionName.class);
        this.version = input.readInt();
        this.content = input.readOptionalString();
        this.user = input.readBoolean() ? new User(input) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeEnum((Enum)this.algorithm);
        out.writeInt(this.version.intValue());
        out.writeOptionalString(this.content);
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(MODEL_NAME, this.name);
        }
        if (this.algorithm != null) {
            builder.field(ALGORITHM, (Object)this.algorithm);
        }
        if (this.version != null) {
            builder.field(MODEL_VERSION, this.version);
        }
        if (this.content != null) {
            builder.field(MODEL_CONTENT, this.content);
        }
        if (this.user != null) {
            builder.field(USER, (ToXContent)this.user);
        }
        builder.endObject();
        return builder;
    }

    public static MLModel parse(XContentParser parser) throws IOException {
        String name = null;
        FunctionName algorithm = null;
        Integer version = null;
        String content = null;
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "content": {
                    content = parser.text();
                    continue block14;
                }
                case "version": {
                    version = parser.intValue(false);
                    continue block14;
                }
                case "user": {
                    user = User.parse((XContentParser)parser);
                    continue block14;
                }
                case "algorithm": {
                    algorithm = FunctionName.from(parser.text());
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return MLModel.builder().name(name).algorithm(algorithm).version(version).content(content).user(user).build();
    }

    public static MLModel fromStream(StreamInput in) throws IOException {
        MLModel mlModel = new MLModel(in);
        return mlModel;
    }

    @Generated
    public static MLModelBuilder builder() {
        return new MLModelBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FunctionName getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public static class MLModelBuilder {
        @Generated
        private String name;
        @Generated
        private FunctionName algorithm;
        @Generated
        private Integer version;
        @Generated
        private String content;
        @Generated
        private User user;

        @Generated
        MLModelBuilder() {
        }

        @Generated
        public MLModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLModelBuilder algorithm(FunctionName algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Generated
        public MLModelBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public MLModelBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public MLModelBuilder user(User user) {
            this.user = user;
            return this;
        }

        @Generated
        public MLModel build() {
            return new MLModel(this.name, this.algorithm, this.version, this.content, this.user);
        }

        @Generated
        public String toString() {
            return "MLModel.MLModelBuilder(name=" + this.name + ", algorithm=" + this.algorithm + ", version=" + this.version + ", content=" + this.content + ", user=" + this.user + ")";
        }
    }
}

