/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Properties;
import org.opensearch.cli.Terminal;
import org.opensearch.common.collect.Tuple;
import org.opensearch.upgrade.TaskInput;
import org.opensearch.upgrade.UpgradeTask;

class ImportLog4jPropertiesTask
implements UpgradeTask {
    static final String LOG4J_PROPERTIES = "log4j2.properties";

    ImportLog4jPropertiesTask() {
    }

    @Override
    public void accept(Tuple<TaskInput, Terminal> input) {
        TaskInput taskInput = (TaskInput)input.v1();
        Terminal terminal = (Terminal)input.v2();
        try {
            terminal.println("Importing log4j.properties ...");
            Path log4jPropPath = taskInput.getOpenSearchConfig().resolve(LOG4J_PROPERTIES);
            if (Files.exists(log4jPropPath, new LinkOption[0])) {
                Files.copy(log4jPropPath, taskInput.getOpenSearchConfig().resolve("log4j2.properties.bkp"), StandardCopyOption.REPLACE_EXISTING);
            }
            Path esLog4jPropPath = taskInput.getEsConfig().resolve(LOG4J_PROPERTIES);
            try (InputStream esLog4jIs = Files.newInputStream(esLog4jPropPath, new OpenOption[0]);
                 OutputStream log4jOs = Files.newOutputStream(log4jPropPath, StandardOpenOption.TRUNCATE_EXISTING);){
                Properties esLog4JProps = new Properties();
                esLog4JProps.load(esLog4jIs);
                Properties log4jProps = this.renameValues(esLog4JProps);
                log4jProps.store(log4jOs, "This is an auto-generated file imported from an existing elasticsearch installation.");
            }
            terminal.println("Success!" + System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying log4j properties. " + e);
        }
    }

    private Properties renameValues(Properties esLog4JProps) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : esLog4JProps.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String newKey = key.replaceAll("esmessagefields", "opensearchmessagefields");
            String newValue = value.replaceAll("ESJsonLayout", "OpenSearchJsonLayout").replaceAll("sys:es.logs", "sys:opensearch.logs").replaceAll("org.elasticsearch", "org.opensearch");
            props.setProperty(newKey, newValue);
        }
        return props;
    }
}

