/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.BoundsChecker;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class HnswGraphSearcher {
    private final VectorSimilarityFunction similarityFunction;
    private final NeighborQueue candidates;
    private final BitSet visited;

    HnswGraphSearcher(VectorSimilarityFunction similarityFunction, NeighborQueue candidates, BitSet visited) {
        this.similarityFunction = similarityFunction;
        this.candidates = candidates;
        this.visited = visited;
    }

    public static NeighborQueue search(float[] query, int topK, RandomAccessVectorValues vectors, VectorSimilarityFunction similarityFunction, HnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        NeighborQueue results;
        HnswGraphSearcher graphSearcher = new HnswGraphSearcher(similarityFunction, new NeighborQueue(topK, !similarityFunction.reversed), new SparseFixedBitSet(vectors.size()));
        int[] eps = new int[]{graph.entryNode()};
        int numVisited = 0;
        for (int level = graph.numLevels() - 1; level >= 1; --level) {
            results = graphSearcher.searchLevel(query, 1, level, eps, vectors, graph, null, visitedLimit);
            eps[0] = results.pop();
            numVisited += results.visitedCount();
            visitedLimit -= results.visitedCount();
        }
        results = graphSearcher.searchLevel(query, topK, 0, eps, vectors, graph, acceptOrds, visitedLimit);
        results.setVisitedCount(results.visitedCount() + numVisited);
        return results;
    }

    NeighborQueue searchLevel(float[] query, int topK, int level, int[] eps, RandomAccessVectorValues vectors, HnswGraph graph) throws IOException {
        return this.searchLevel(query, topK, level, eps, vectors, graph, null, Integer.MAX_VALUE);
    }

    private NeighborQueue searchLevel(float[] query, int topK, int level, int[] eps, RandomAccessVectorValues vectors, HnswGraph graph, Bits acceptOrds, int visitedLimit) throws IOException {
        float topCandidateScore;
        float score;
        int size = graph.size();
        NeighborQueue results = new NeighborQueue(topK, this.similarityFunction.reversed);
        this.clearScratchState();
        int numVisited = 0;
        for (int ep : eps) {
            if (this.visited.getAndSet(ep)) continue;
            if (numVisited >= visitedLimit) {
                results.markIncomplete();
                break;
            }
            score = this.similarityFunction.compare(query, vectors.vectorValue(ep));
            ++numVisited;
            this.candidates.add(ep, score);
            if (acceptOrds != null && !acceptOrds.get(ep)) continue;
            results.add(ep, score);
        }
        BoundsChecker bound = BoundsChecker.create(this.similarityFunction.reversed);
        if (results.size() >= topK) {
            bound.set(results.topScore());
        }
        block1: while (this.candidates.size() > 0 && !results.incomplete() && !bound.check(topCandidateScore = this.candidates.topScore())) {
            int friendOrd;
            int topCandidateNode = this.candidates.pop();
            graph.seek(level, topCandidateNode);
            while ((friendOrd = graph.nextNeighbor()) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (this.visited.getAndSet(friendOrd)) continue;
                if (numVisited >= visitedLimit) {
                    results.markIncomplete();
                    continue block1;
                }
                score = this.similarityFunction.compare(query, vectors.vectorValue(friendOrd));
                ++numVisited;
                if (bound.check(score)) continue;
                this.candidates.add(friendOrd, score);
                if (acceptOrds != null && !acceptOrds.get(friendOrd) || !results.insertWithOverflow(friendOrd, score) || results.size() < topK) continue;
                bound.set(results.topScore());
            }
        }
        while (results.size() > topK) {
            results.pop();
        }
        results.setVisitedCount(numVisited);
        return results;
    }

    private void clearScratchState() {
        this.candidates.clear();
        this.visited.clear(0, this.visited.length());
    }
}

