/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.java_version_checker;

import java.util.Arrays;
import java.util.Locale;
import org.opensearch.tools.java_version_checker.JavaVersion;
import org.opensearch.tools.java_version_checker.SuppressForbidden;

final class JavaVersionChecker {
    private JavaVersionChecker() {
    }

    public static void main(String[] args) {
        String message;
        if (args.length != 0) {
            throw new IllegalArgumentException("expected zero arguments but was " + Arrays.toString(args));
        }
        if (JavaVersion.compare(JavaVersion.CURRENT, JavaVersion.JAVA_8) < 0) {
            message = String.format(Locale.ROOT, "the minimum required Java version is 8; your Java version from [%s] does not meet this requirement", System.getProperty("java.home"));
            JavaVersionChecker.errPrintln(message);
            JavaVersionChecker.exit(1);
        }
        if (JavaVersion.compare(JavaVersion.CURRENT, JavaVersion.JAVA_11) < 0) {
            message = String.format(Locale.ROOT, "future versions of OpenSearch will require Java 11; your Java version from [%s] does not meet this requirement", System.getProperty("java.home"));
            JavaVersionChecker.errPrintln(message);
        }
        JavaVersionChecker.exit(0);
    }

    @SuppressForbidden(reason="System#err")
    static void errPrintln(String message) {
        System.err.println(message);
    }

    @SuppressForbidden(reason="System#exit")
    static void exit(int status) {
        System.exit(status);
    }
}

