/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.action.preview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.indexmanagement.transform.TransformSearchService;
import org.opensearch.indexmanagement.transform.TransformValidator;
import org.opensearch.indexmanagement.transform.action.preview.PreviewTransformRequest;
import org.opensearch.indexmanagement.transform.action.preview.PreviewTransformResponse;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformSearchResult;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B/\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014J$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018J*\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/opensearch/indexmanagement/transform/action/preview/TransportPreviewTransformAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/transform/action/preview/PreviewTransformRequest;", "Lorg/opensearch/indexmanagement/transform/action/preview/PreviewTransformResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "executeSearch", "searchRequest", "Lorg/opensearch/action/search/SearchRequest;", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "validateMappings", "", "", "indices", "response", "Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "opensearch-index-management"})
public final class TransportPreviewTransformAction
extends HandledTransportAction<PreviewTransformRequest, PreviewTransformResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Logger log;

    @Inject
    public TransportPreviewTransformAction(@NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        super("cluster:admin/opendistro/transform/preview", transportService, actionFilters, PreviewTransformRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
    }

    protected void doExecute(@NotNull Task task, @NotNull PreviewTransformRequest request, @NotNull ActionListener<PreviewTransformResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        Transform transform2 = request.getTransform();
        String[] stringArray = new String[]{transform2.getSourceIndex()};
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpand(), true, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)concreteIndices, (String)"concreteIndices");
        if (concreteIndices.length == 0) {
            listener.onFailure((Exception)new OpenSearchStatusException("No specified source index exist in the cluster", RestStatus.NOT_FOUND, new Object[0]));
            return;
        }
        GetMappingsRequest mappingRequest = (GetMappingsRequest)new GetMappingsRequest().indices(Arrays.copyOf(concreteIndices, concreteIndices.length));
        this.client.execute((ActionType)GetMappingsAction.INSTANCE, (ActionRequest)mappingRequest, (ActionListener)new ActionListener<GetMappingsResponse>(this, concreteIndices, transform2, listener){
            final /* synthetic */ TransportPreviewTransformAction this$0;
            final /* synthetic */ String[] $concreteIndices;
            final /* synthetic */ Transform $transform;
            final /* synthetic */ ActionListener<PreviewTransformResponse> $listener;
            {
                this.this$0 = $receiver;
                this.$concreteIndices = $concreteIndices;
                this.$transform = $transform;
                this.$listener = $listener;
            }

            public void onResponse(@NotNull GetMappingsResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                String[] stringArray = this.$concreteIndices;
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"concreteIndices");
                List<String> issues = this.this$0.validateMappings(ArraysKt.toList((Object[])stringArray), response2, this.$transform);
                if (!((Collection)issues).isEmpty()) {
                    String errorMessage = CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                    this.$listener.onFailure((Exception)new OpenSearchStatusException(errorMessage, RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                SearchRequest searchRequest = TransformSearchService.Companion.getSearchServiceRequest$default(TransformSearchService.Companion, this.$transform, null, 10, null, 10, null);
                this.this$0.executeSearch(searchRequest, this.$transform, this.$listener);
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
        });
    }

    @NotNull
    public final List<String> validateMappings(@NotNull List<String> indices, @NotNull GetMappingsResponse response2, @NotNull Transform transform2) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        List issues = new ArrayList();
        Iterable $this$forEach$iv = indices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String index2 = (String)element$iv;
            boolean bl = false;
            issues.addAll((Collection)TransformValidator.Companion.validateMappingsResponse(index2, response2, transform2));
        }
        return issues;
    }

    public final void executeSearch(@NotNull SearchRequest searchRequest, @NotNull Transform transform2, @NotNull ActionListener<PreviewTransformResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)searchRequest, (String)"searchRequest");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(transform2, listener){
            final /* synthetic */ Transform $transform;
            final /* synthetic */ ActionListener<PreviewTransformResponse> $listener;
            {
                this.$transform = $transform;
                this.$listener = $listener;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                try {
                    void $this$mapTo$iv$iv;
                    TransformSearchResult transformSearchResult2 = TransformSearchService.Companion.convertResponse$default(TransformSearchService.Companion, this.$transform, response2, false, null, 8, null);
                    Iterable $this$map$iv = transformSearchResult2.getDocsToIndex();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IndexRequest indexRequest = (IndexRequest)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.sourceAsMap());
                    }
                    List formattedResult = (List)destination$iv$iv;
                    this.$listener.onResponse((Object)((Object)new PreviewTransformResponse(formattedResult, RestStatus.OK)));
                }
                catch (Exception e) {
                    this.$listener.onFailure((Exception)new OpenSearchStatusException("Failed to parse the transformed results", RestStatus.INTERNAL_SERVER_ERROR, ExceptionsHelper.unwrapCause((Throwable)e), new Object[0]));
                }
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
        });
    }
}

