/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.DisMaxQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupFieldMapping;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\u0016\u001a&\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fH\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0002J(\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010)\u001a\u0004\u0018\u00010*2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0$H\u0002J>\u0010+\u001a\b\u0012\u0004\u0012\u0002H-0,\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u00112\f\u00102\u001a\b\u0012\u0004\u0012\u0002H-0,H\u0016J\u0016\u00103\u001a\u00020\u00192\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190\u001aH\u0002J*\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0018\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006:"}, d2={"Lorg/opensearch/indexmanagement/rollup/interceptor/RollupInterceptor;", "Lorg/opensearch/transport/TransportInterceptor;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getIndexNameExpressionResolver", "()Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "searchAllJobs", "", "Ljava/lang/Boolean;", "searchEnabled", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "findMatchingRollupJobs", "Lkotlin/Pair;", "", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "", "Lorg/opensearch/indexmanagement/rollup/model/RollupFieldMapping;", "", "fieldMappings", "rollupJobs", "", "getAggregationMetadata", "aggregationBuilders", "", "Lorg/opensearch/search/aggregations/AggregationBuilder;", "", "getEstimateRollupInterval", "", "rollup", "getQueryMetadata", "query", "Lorg/opensearch/index/query/QueryBuilder;", "interceptHandler", "Lorg/opensearch/transport/TransportRequestHandler;", "T", "Lorg/opensearch/transport/TransportRequest;", "action", "executor", "forceExecution", "actualHandler", "pickRollupJob", "rollups", "rewriteShardSearchForRollupJobs", "", "request", "Lorg/opensearch/search/internal/ShardSearchRequest;", "matchingRollupJobs", "opensearch-index-management"})
public final class RollupInterceptor
implements TransportInterceptor {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Logger logger;
    private volatile Boolean searchEnabled;
    private volatile Boolean searchAllJobs;

    public RollupInterceptor(@NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.logger = LogManager.getLogger(this.getClass());
        this.searchEnabled = (Boolean)RollupSettings.Companion.getROLLUP_SEARCH_ENABLED().get(this.settings);
        this.searchAllJobs = (Boolean)RollupSettings.Companion.getROLLUP_SEARCH_ALL_JOBS().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_ENABLED(), arg_0 -> RollupInterceptor._init_$lambda-0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.Companion.getROLLUP_SEARCH_ALL_JOBS(), arg_0 -> RollupInterceptor._init_$lambda-1(this, arg_0));
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    @NotNull
    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(@NotNull String action, @NotNull String executor, boolean forceExecution, @NotNull TransportRequestHandler<T> actualHandler) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(actualHandler, (String)"actualHandler");
        return new TransportRequestHandler<T>(this, actualHandler){
            final /* synthetic */ RollupInterceptor this$0;
            final /* synthetic */ TransportRequestHandler<T> $actualHandler;
            {
                this.this$0 = $receiver;
                this.$actualHandler = $actualHandler;
            }

            /*
             * WARNING - void declaration
             */
            public void messageReceived(@NotNull T request, @NotNull TransportChannel channel, @NotNull Task task) {
                Intrinsics.checkNotNullParameter(request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Boolean bl = RollupInterceptor.access$getSearchEnabled$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"searchEnabled");
                if (bl.booleanValue() && request instanceof ShardSearchRequest) {
                    String index2 = ((ShardSearchRequest)request).shardId().getIndexName();
                    Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"index");
                    ClusterState clusterState = this.this$0.getClusterService().state();
                    Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"clusterService.state()");
                    boolean isRollupIndex = RollupUtilsKt.isRollupIndex(index2, clusterState);
                    if (isRollupIndex) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv;
                        if (((ShardSearchRequest)request).source().size() != 0) {
                            throw new IllegalArgumentException("Rollup search must have size explicitly set to 0, but found " + ((ShardSearchRequest)request).source().size());
                        }
                        String[] stringArray = ((ShardSearchRequest)request).indices();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"request.indices()");
                        Object $this$map$iv = stringArray;
                        boolean $i$f$map = false;
                        Object[] objectArray = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((Object[])$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.toString());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        List<Rollup> thisCollection$iv = $this$toTypedArray$iv;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        if (stringArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] indices = stringArray2;
                        String[] concreteIndices = this.this$0.getIndexNameExpressionResolver().concreteIndexNames(this.this$0.getClusterService().state(), ((ShardSearchRequest)request).indicesOptions(), Arrays.copyOf(indices, indices.length));
                        if (concreteIndices.length > 1) {
                            RollupInterceptor.access$getLogger$p(this.this$0).warn("There can be only one index in search request if its a rollup search - requested to search [" + concreteIndices.length + "] indices including rollup index [" + index2 + "]");
                            throw new IllegalArgumentException("Searching rollup index with other indices is not supported currently");
                        }
                        destination$iv$iv = this.this$0.getClusterService().state().getMetadata().index(index2);
                        Intrinsics.checkNotNullExpressionValue((Object)destination$iv$iv, (String)"clusterService.state().metadata.index(index)");
                        thisCollection$iv = RollupUtilsKt.getRollupJobs((IndexMetadata)destination$iv$iv);
                        if (thisCollection$iv == null) {
                            throw new IllegalArgumentException("Could not find any valid rollup job on the index");
                        }
                        List<Rollup> rollupJobs = thisCollection$iv;
                        Set queryFieldMappings = RollupInterceptor.getQueryMetadata$default(this.this$0, ((ShardSearchRequest)request).source().query(), null, 2, null);
                        AggregatorFactories.Builder builder = ((ShardSearchRequest)request).source().aggregations();
                        Set aggregationFieldMappings = RollupInterceptor.getAggregationMetadata$default(this.this$0, (Collection)(builder == null ? null : builder.getAggregatorFactories()), null, 2, null);
                        Set fieldMappings = SetsKt.plus((Set)queryFieldMappings, (Iterable)aggregationFieldMappings);
                        Pair pair = RollupInterceptor.access$findMatchingRollupJobs(this.this$0, fieldMappings, rollupJobs);
                        Map matchingRollupJobs = (Map)pair.component1();
                        Set issues = (Set)pair.component2();
                        if (matchingRollupJobs.isEmpty()) {
                            throw new IllegalArgumentException("Could not find a rollup job that can answer this query because " + issues);
                        }
                        if (!((Collection)fieldMappings).isEmpty()) {
                            RollupInterceptor.access$rewriteShardSearchForRollupJobs(this.this$0, (ShardSearchRequest)request, matchingRollupJobs);
                        }
                    }
                }
                this.$actualHandler.messageReceived(request, channel, task);
            }
        };
    }

    private final Set<RollupFieldMapping> getAggregationMetadata(Collection<? extends AggregationBuilder> aggregationBuilders, Set<RollupFieldMapping> fieldMappings) {
        Collection<? extends AggregationBuilder> collection = aggregationBuilders;
        if (collection != null) {
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                AggregationBuilder it = (AggregationBuilder)element$iv;
                boolean bl = false;
                Object object = it;
                if (object instanceof TermsAggregationBuilder) {
                    string = ((TermsAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string2 = string;
                    string = ((TermsAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string2, string, null, 8, null));
                } else if (object instanceof DateHistogramAggregationBuilder) {
                    string = ((DateHistogramAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string3 = string;
                    string = ((DateHistogramAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string3, string, null, 8, null));
                } else if (object instanceof HistogramAggregationBuilder) {
                    string = ((HistogramAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string4 = string;
                    string = ((HistogramAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string4, string, null, 8, null));
                } else if (object instanceof SumAggregationBuilder) {
                    string = ((SumAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string5 = string;
                    string = ((SumAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string5, string, null, 8, null));
                } else if (object instanceof AvgAggregationBuilder) {
                    string = ((AvgAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string6 = string;
                    string = ((AvgAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string6, string, null, 8, null));
                } else if (object instanceof MaxAggregationBuilder) {
                    string = ((MaxAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string7 = string;
                    string = ((MaxAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string7, string, null, 8, null));
                } else if (object instanceof MinAggregationBuilder) {
                    string = ((MinAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string8 = string;
                    string = ((MinAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string8, string, null, 8, null));
                } else if (object instanceof ValueCountAggregationBuilder) {
                    string = ((ValueCountAggregationBuilder)it).field();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.field()");
                    String string9 = string;
                    string = ((ValueCountAggregationBuilder)it).getType();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.type");
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.METRIC, string9, string, null, 8, null));
                } else {
                    throw new IllegalArgumentException("The " + it.getType() + " aggregation is not currently supported in rollups");
                }
                if (!((object = it.getSubAggregations()) == null ? false : !object.isEmpty())) continue;
                this.getAggregationMetadata(it.getSubAggregations(), fieldMappings);
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getAggregationMetadata$default(RollupInterceptor rollupInterceptor, Collection collection, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getAggregationMetadata(collection, set);
    }

    private final Set<RollupFieldMapping> getQueryMetadata(QueryBuilder query, Set<RollupFieldMapping> fieldMappings) {
        if (query == null) {
            return fieldMappings;
        }
        QueryBuilder queryBuilder = query;
        if (queryBuilder instanceof TermQueryBuilder) {
            String string = ((TermQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof TermsQueryBuilder) {
            String string = ((TermsQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, Dimension.Type.TERMS.getType(), null, 8, null));
        } else if (queryBuilder instanceof RangeQueryBuilder) {
            String string = ((RangeQueryBuilder)query).fieldName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"query.fieldName()");
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, string, "unknown", null, 8, null));
        } else if (!(queryBuilder instanceof MatchAllQueryBuilder)) {
            if (queryBuilder instanceof BoolQueryBuilder) {
                QueryBuilder it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                List list = ((BoolQueryBuilder)query).must();
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list2 = ((BoolQueryBuilder)query).mustNot();
                if (list2 != null) {
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list3 = ((BoolQueryBuilder)query).should();
                if (list3 != null) {
                    $this$forEach$iv = list3;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
                List list4 = ((BoolQueryBuilder)query).filter();
                if (list4 != null) {
                    $this$forEach$iv = list4;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (QueryBuilder)element$iv;
                        boolean bl = false;
                        this.getQueryMetadata(it, fieldMappings);
                    }
                }
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                this.getQueryMetadata(((BoostingQueryBuilder)query).positiveQuery(), fieldMappings);
                this.getQueryMetadata(((BoostingQueryBuilder)query).negativeQuery(), fieldMappings);
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                this.getQueryMetadata(((ConstantScoreQueryBuilder)query).innerQuery(), fieldMappings);
            } else if (queryBuilder instanceof DisMaxQueryBuilder) {
                List list = ((DisMaxQueryBuilder)query).innerQueries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query.innerQueries()");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    QueryBuilder it = (QueryBuilder)element$iv;
                    boolean bl = false;
                    this.getQueryMetadata(it, fieldMappings);
                }
            } else if (queryBuilder instanceof MatchPhraseQueryBuilder) {
                CharSequence charSequence = ((MatchPhraseQueryBuilder)query).analyzer();
                if (!(charSequence == null || charSequence.length() == 0) || ((MatchPhraseQueryBuilder)query).slop() != 0 || ((MatchPhraseQueryBuilder)query).zeroTermsQuery() != MatchQuery.DEFAULT_ZERO_TERMS_QUERY) {
                    throw new IllegalArgumentException("The " + ((MatchPhraseQueryBuilder)query).getName() + " query is currently not supported with analyzer/slop/zero_terms_query in rollups");
                }
                charSequence = ((MatchPhraseQueryBuilder)query).fieldName();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"query.fieldName()");
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.Companion.FieldType.DIMENSION, (String)charSequence, Dimension.Type.TERMS.getType(), null, 8, null));
            } else {
                throw new IllegalArgumentException("The " + query.getName() + " query is currently not supported in rollups");
            }
        }
        return fieldMappings;
    }

    static /* synthetic */ Set getQueryMetadata$default(RollupInterceptor rollupInterceptor, QueryBuilder queryBuilder, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return rollupInterceptor.getQueryMetadata(queryBuilder, set);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> findMatchingRollupJobs(Set<RollupFieldMapping> fieldMappings, List<Rollup> rollupJobs) {
        $this$map$iv = rollupJobs;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_18 = (Rollup)item$iv$iv;
            var24_27 = destination$iv$iv;
            $i$a$-map-RollupInterceptor$findMatchingRollupJobs$rollupFieldMappings$1 = false;
            var24_27.add(TuplesKt.to((Object)rollup, RollupUtilsKt.populateFieldMappings((Rollup)rollup)));
        }
        rollupFieldMappings = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        knownFieldMappings = new LinkedHashSet<E>();
        unknownFields = new LinkedHashSet<E>();
        $this$forEach$iv = fieldMappings;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (RollupFieldMapping)element$iv;
            $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$1 = false;
            if (Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown")) {
                unknownFields.add(it.getFieldName());
                continue;
            }
            knownFieldMappings.add(it);
        }
        $this$filterValues$iv = rollupFieldMappings;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            it = (Set)entry$iv.getValue();
            $i$a$-filterValues-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1 = false;
            if (!it.containsAll(knownFieldMappings)) ** GOTO lbl-1000
            $this$map$iv = it;
            $i$f$map = false;
            var16_39 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var21_44 = (RollupFieldMapping)item$iv$iv;
                var22_45 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$potentialRollupFieldMappings$1$1 = false;
                var22_45.add(rollupFieldMapping.getFieldName());
            }
            if (((List)destination$iv$iv).containsAll(unknownFields)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        potentialRollupFieldMappings = result$iv;
        issues = new LinkedHashSet<E>();
        if (potentialRollupFieldMappings.isEmpty()) {
            allFieldMappings = new LinkedHashSet<E>();
            $this$forEach$iv = rollupFieldMappings.values();
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (Set)element$iv;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$2 = false;
                allFieldMappings.addAll(it);
            }
            $this$map$iv = allFieldMappings;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv = (RollupFieldMapping)item$iv$iv;
                var24_27 = destination$iv$iv;
                $i$a$-map-RollupInterceptor$findMatchingRollupJobs$allFields$1 = false;
                var24_27.add(it.getFieldName());
            }
            allFields = (List)destination$iv$iv;
            $this$forEach$iv = fieldMappings;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (RollupFieldMapping)element$iv;
                $i$a$-forEach-RollupInterceptor$findMatchingRollupJobs$3 = false;
                if (!allFields.contains(it.getFieldName())) {
                    issues.add(it.toIssue(true));
                    continue;
                }
                if (Intrinsics.areEqual((Object)it.getMappingType(), (Object)"unknown") || allFieldMappings.contains(it)) continue;
                issues.add(RollupFieldMapping.toIssue$default(it, false, 1, null));
            }
        }
        return TuplesKt.to((Object)potentialRollupFieldMappings, (Object)issues);
    }

    /*
     * WARNING - void declaration
     */
    private final Rollup pickRollupJob(Set<Rollup> rollups2) {
        if (rollups2.size() == 1) {
            return (Rollup)CollectionsKt.first((Iterable)rollups2);
        }
        Iterable $this$reduce$iv = rollups2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void new_;
            Rollup rollup2 = (Rollup)iterator$iv.next();
            Rollup matched = (Rollup)accumulator$iv;
            boolean bl = false;
            accumulator$iv = this.getEstimateRollupInterval(matched) > this.getEstimateRollupInterval((Rollup)new_) ? matched : new_;
        }
        return (Rollup)accumulator$iv;
    }

    private final long getEstimateRollupInterval(Rollup rollup2) {
        return RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval() != null ? new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getCalendarInterval()).estimateMillis() : new DateHistogramInterval(RollupUtilsKt.getDateHistogram(rollup2).getFixedInterval()).estimateMillis();
    }

    /*
     * WARNING - void declaration
     */
    private final void rewriteShardSearchForRollupJobs(ShardSearchRequest request, Map<Rollup, ? extends Set<RollupFieldMapping>> matchingRollupJobs) {
        void $this$associateByTo$iv$iv;
        Rollup matchedRollup = this.pickRollupJob(matchingRollupJobs.keySet());
        Iterable $this$associateBy$iv = (Iterable)MapsKt.getValue(matchingRollupJobs, (Object)matchedRollup);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            RollupFieldMapping rollupFieldMapping = (RollupFieldMapping)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            RollupFieldMapping it = (RollupFieldMapping)element$iv$iv;
            String string = it.getFieldName();
            boolean bl2 = false;
            String string2 = it.getMappingType();
            map.put(string, string2);
        }
        Map fieldNameMappingTypeMap = destination$iv$iv;
        Boolean bl = this.searchAllJobs;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"searchAllJobs");
        if (bl.booleanValue()) {
            bl = request.source();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"request.source()");
            request.source(RollupUtilsKt.rewriteSearchSourceBuilder((SearchSourceBuilder)bl, matchingRollupJobs.keySet(), (Map<String, String>)fieldNameMappingTypeMap));
        } else {
            bl = request.source();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"request.source()");
            request.source(RollupUtilsKt.rewriteSearchSourceBuilder((SearchSourceBuilder)bl, matchedRollup, (Map<String, String>)fieldNameMappingTypeMap));
        }
    }

    private static final void _init_$lambda-0(RollupInterceptor this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.searchEnabled = it;
    }

    private static final void _init_$lambda-1(RollupInterceptor this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.searchAllJobs = it;
    }

    public static final /* synthetic */ Boolean access$getSearchEnabled$p(RollupInterceptor $this) {
        return $this.searchEnabled;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RollupInterceptor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Pair access$findMatchingRollupJobs(RollupInterceptor $this, Set fieldMappings, List rollupJobs) {
        return $this.findMatchingRollupJobs(fieldMappings, rollupJobs);
    }

    public static final /* synthetic */ void access$rewriteShardSearchForRollupJobs(RollupInterceptor $this, ShardSearchRequest request, Map matchingRollupJobs) {
        $this.rewriteShardSearchForRollupJobs(request, matchingRollupJobs);
    }
}

