/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.migration;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.opensearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.opensearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.migration.ISMTemplateService;
import org.opensearch.indexmanagement.migration.V1TemplateCache;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.rest.RestStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@OpenForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010/\u001a\u000200H\u0012J\b\u00101\u001a\u000200H\u0012J\u0019\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u0017H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u00105\u001a\u000200H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0011\u00107\u001a\u000200H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0010\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001cH\u0012J\b\u0010:\u001a\u000200H\u0012J\b\u0010;\u001a\u000200H\u0012J&\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\u00122\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00120?2\u0006\u0010@\u001a\u00020\u001cH\u0012J\b\u0010A\u001a\u000200H\u0012J\b\u0010B\u001a\u000200H\u0016J\u0018\u0010C\u001a\u0002002\u0006\u0010=\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u0015H\u0012J\u001b\u0010E\u001a\u0004\u0018\u00010\u00122\u0006\u0010F\u001a\u00020\u0012H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0010\u0010H\u001a\u0002002\u0006\u0010I\u001a\u00020!H\u0012J\u0011\u0010J\u001a\u000200H\u0092@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u000e\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u0018\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0011X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u001e0\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001f\u001a\"\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0 j\u0002`\"0\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n \u001a*\u0004\u0018\u00010$0$X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010*\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`+\u0012\u0004\u0012\u00020,0\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u0018\u0012\u0004\u0012\u00020\u001c\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0012j\u0002`+0\u00140\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Lorg/opensearch/indexmanagement/migration/ISMTemplateService;", "", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "imIndices", "Lorg/opensearch/indexmanagement/IndexManagementIndices;", "(Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/xcontent/NamedXContentRegistry;Lorg/opensearch/indexmanagement/IndexManagementIndices;)V", "<set-?>", "", "finishFlag", "getFinishFlag", "()Z", "ismTemplateMap", "", "", "Lorg/opensearch/indexmanagement/migration/policyID;", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "lastUpdatedTime", "Ljava/time/Instant;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "negOrderToPositive", "", "policiesFailedToUpdate", "Lorg/opensearch/action/bulk/BulkItemResponse$Failure;", "policiesToUpdate", "Lkotlin/Pair;", "", "Lorg/opensearch/indexmanagement/migration/seqNoPrimaryTerm;", "retryPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "runTimeCounter", "getRunTimeCounter", "()I", "setRunTimeCounter", "(I)V", "v1TemplatesWithPolicyID", "Lorg/opensearch/indexmanagement/migration/templateName;", "Lorg/opensearch/indexmanagement/migration/V1TemplateCache;", "v1orderToBucketIncrement", "v1orderToTemplatesName", "bucketizeV1TemplatesByOrder", "", "cleanCache", "doMigration", "timeStamp", "(Ljava/time/Instant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getISMPolicies", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIndexTemplates", "normalizePriority", "order", "populateBucketPriority", "populateV1Template", "populateV2ISMTemplateMap", "policyID", "indexPatterns", "", "priority", "processNegativeOrder", "reenableTemplateMigration", "saveISMTemplateToMap", "ismTemplate", "simulateTemplate", "templateName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopMigration", "successFlag", "updateISMPolicies", "updateSettingListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsResponse;", "opensearch-index-management"})
public class ISMTemplateService {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final IndexManagementIndices imIndices;
    private final Logger logger;
    private volatile boolean finishFlag;
    private volatile int runTimeCounter;
    @NotNull
    private Map<String, List<ISMTemplate>> ismTemplateMap;
    @NotNull
    private final Map<String, V1TemplateCache> v1TemplatesWithPolicyID;
    @NotNull
    private final Map<Integer, Integer> negOrderToPositive;
    @NotNull
    private final Map<Integer, List<String>> v1orderToTemplatesName;
    @NotNull
    private final Map<Integer, Integer> v1orderToBucketIncrement;
    @NotNull
    private final Map<String, Pair<Long, Long>> policiesToUpdate;
    @NotNull
    private final Map<String, BulkItemResponse.Failure> policiesFailedToUpdate;
    private Instant lastUpdatedTime;
    private volatile BackoffPolicy retryPolicy;

    public ISMTemplateService(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull IndexManagementIndices imIndices) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)imIndices, (String)"imIndices");
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.imIndices = imIndices;
        this.logger = LogManager.getLogger(this.getClass());
        this.ismTemplateMap = new LinkedHashMap();
        this.v1TemplatesWithPolicyID = new LinkedHashMap();
        this.negOrderToPositive = new LinkedHashMap();
        this.v1orderToTemplatesName = new LinkedHashMap();
        this.v1orderToBucketIncrement = new LinkedHashMap();
        this.policiesToUpdate = new LinkedHashMap();
        this.policiesFailedToUpdate = new LinkedHashMap();
        this.retryPolicy = BackoffPolicy.constantBackoff((TimeValue)TimeValue.timeValueMillis((long)50L), (int)3);
    }

    public final boolean getFinishFlag() {
        return this.finishFlag;
    }

    public void reenableTemplateMigration() {
        this.finishFlag = false;
    }

    public int getRunTimeCounter() {
        return this.runTimeCounter;
    }

    public void setRunTimeCounter(int n) {
        this.runTimeCounter = n;
    }

    @Nullable
    public Object doMigration(@NotNull Instant timeStamp, @NotNull Continuation<? super Unit> $completion) {
        return ISMTemplateService.doMigration$suspendImpl(this, timeStamp, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object doMigration$suspendImpl(ISMTemplateService var0, Instant var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof doMigration.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super doMigration.1>)var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ISMTemplateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ISMTemplateService.doMigration$suspendImpl(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getRunTimeCounter() >= 10) {
                    this.stopMigration(-2L);
                    return Unit.INSTANCE;
                }
                this.setRunTimeCounter(this.getRunTimeCounter() + 1);
                this.logger.info("Doing ISM template migration " + this.getRunTimeCounter() + " time.");
                this.cleanCache();
                var3_6 = timeStamp.minusSeconds(3600L);
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"timeStamp.minusSeconds(3600)");
                this.lastUpdatedTime = var3_6;
                v0 = this.lastUpdatedTime;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastUpdatedTime");
                    v0 = null;
                }
                this.logger.info("Use " + v0 + " as migrating ISM template last_updated_time");
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.getIndexTemplates((Continuation<? super Unit>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                this = (ISMTemplateService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                this.logger.info("ISM templates: " + this.ismTemplateMap);
                $continuation.L$0 = this;
                $continuation.label = 2;
                v2 = this.getISMPolicies((Continuation<? super Unit>)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl47
            }
            case 2: {
                this = (ISMTemplateService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl47:
                // 2 sources

                this.logger.info("Policies to update: " + this.policiesToUpdate.keySet());
                $continuation.L$0 = this;
                $continuation.label = 3;
                v3 = this.updateISMPolicies((Continuation<? super Unit>)$continuation);
                if (v3 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl58
            }
            case 3: {
                this = (ISMTemplateService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl58:
                // 2 sources

                if (this.policiesToUpdate.isEmpty()) {
                    this.stopMigration(-1L);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private void stopMigration(long successFlag) {
        this.finishFlag = true;
        Settings.Builder newSetting = Settings.builder().put(ManagedIndexSettings.Companion.getTEMPLATE_MIGRATION_CONTROL().getKey(), successFlag);
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest().persistentSettings(newSetting);
        this.client.admin().cluster().updateSettings(request, this.updateSettingListener());
        this.logger.info("Failure experienced when migrating ISM Template and update ISM policies: " + this.policiesFailedToUpdate);
        this.setRunTimeCounter(0);
    }

    private ActionListener<ClusterUpdateSettingsResponse> updateSettingListener() {
        return (ActionListener)new ActionListener<ClusterUpdateSettingsResponse>(this){
            final /* synthetic */ ISMTemplateService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(@NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ISMTemplateService.access$getLogger$p(this.this$0).error("Failed to update template migration setting", (Throwable)e);
            }

            public void onResponse(@NotNull ClusterUpdateSettingsResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isAcknowledged()) {
                    ISMTemplateService.access$getLogger$p(this.this$0).error("Update template migration setting is not acknowledged");
                } else {
                    ISMTemplateService.access$getLogger$p(this.this$0).info("Successfully update template migration setting");
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private Object getIndexTemplates(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof getIndexTemplates.1)) ** GOTO lbl-1000
        var14_2 = var1_1;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ISMTemplateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ISMTemplateService.access$getIndexTemplates(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.processNegativeOrder();
                this.bucketizeV1TemplatesByOrder();
                this.populateBucketPriority();
                this.populateV1Template();
                var2_5 = this.clusterService.state().getMetadata().templatesV2();
                Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"clusterService.state().metadata.templatesV2()");
                $i$f$forEach = false;
                var4_7 = $this$forEach$iv.entrySet().iterator();
lbl20:
                // 3 sources

                while (var4_7.hasNext()) {
                    it = element$iv = var4_7.next();
                    $i$a$-forEach-ISMTemplateService$getIndexTemplates$2 = false;
                    template = (ComposableIndexTemplate)it.getValue();
                    indexPatterns = template.indexPatterns();
                    priority = (int)template.priorityOrZero();
                    var11_14 = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(var11_14, (String)"it.key");
                    $continuation.L$0 = this;
                    $continuation.L$1 = var4_7;
                    $continuation.L$2 = indexPatterns;
                    $continuation.I$0 = priority;
                    $continuation.label = 1;
                    v0 = this.simulateTemplate((String)var11_14, (Continuation<? super String>)$continuation);
                    if (v0 == var15_4) {
                        return var15_4;
                    }
                    ** GOTO lbl47
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-ISMTemplateService$getIndexTemplates$2 = false;
                priority = $continuation.I$0;
                indexPatterns = (List)$continuation.L$2;
                var4_7 = (Iterator<Map.Entry<K, V>>)$continuation.L$1;
                this = (ISMTemplateService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl47:
                // 2 sources

                if ((policyIDSetting = (String)v0) == null) ** GOTO lbl20
                Intrinsics.checkNotNullExpressionValue((Object)indexPatterns, (String)"indexPatterns");
                this.populateV2ISMTemplateMap(policyIDSetting, indexPatterns, priority);
                ** GOTO lbl20
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private void processNegativeOrder() {
        Set negOrderSet = new LinkedHashSet();
        ImmutableOpenMap immutableOpenMap = this.clusterService.state().getMetadata().getTemplates();
        Intrinsics.checkNotNullExpressionValue((Object)immutableOpenMap, (String)"clusterService.state().metadata.templates");
        Iterable $this$forEach$iv = (Iterable)immutableOpenMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
            boolean bl = false;
            String policyIDSetting = (String)ManagedIndexSettings.Companion.getPOLICY_ID().get(((IndexTemplateMetadata)it.value).settings());
            if (Intrinsics.areEqual((Object)policyIDSetting, (Object)"")) continue;
            int priority = ((IndexTemplateMetadata)it.value).getOrder();
            if (priority < 0) {
                negOrderSet.add(priority);
            }
            Object object = it.key;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.key");
            List list = ((IndexTemplateMetadata)it.value).patterns();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.value.patterns()");
            Intrinsics.checkNotNullExpressionValue((Object)policyIDSetting, (String)"policyIDSetting");
            this.v1TemplatesWithPolicyID.put((String)object, new V1TemplateCache(list, 0, policyIDSetting));
        }
        List sorted = CollectionsKt.sorted((Iterable)negOrderSet);
        int p = 0;
        Iterator<Object> iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            Map<Integer, Integer> map = this.negOrderToPositive;
            Integer n = i;
            int n2 = p;
            p = n2 + 1;
            Integer n3 = n2;
            map.put(n, n3);
        }
    }

    private int normalizePriority(int order) {
        if (order < 0) {
            Integer n = this.negOrderToPositive.get(order);
            return n == null ? 0 : n;
        }
        return order + this.negOrderToPositive.size();
    }

    private void bucketizeV1TemplatesByOrder() {
        ImmutableOpenMap immutableOpenMap = this.clusterService.state().getMetadata().getTemplates();
        Intrinsics.checkNotNullExpressionValue((Object)immutableOpenMap, (String)"clusterService.state().metadata.templates");
        Iterable $this$forEach$iv = (Iterable)immutableOpenMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObjectObjectCursor it = (ObjectObjectCursor)element$iv;
            boolean bl = false;
            V1TemplateCache v1TemplateCache = this.v1TemplatesWithPolicyID.get(it.key);
            if (v1TemplateCache == null) continue;
            int priority = this.normalizePriority(((IndexTemplateMetadata)it.value).getOrder());
            Map<String, V1TemplateCache> map = this.v1TemplatesWithPolicyID;
            Object object = it.key;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.key");
            Object object2 = V1TemplateCache.copy$default(v1TemplateCache, null, priority, null, 5, null);
            map.put((String)object, (V1TemplateCache)object2);
            List<String> bucket = this.v1orderToTemplatesName.get(priority);
            if (bucket == null) {
                object = this.v1orderToTemplatesName;
                object2 = priority;
                Object object3 = new String[1];
                Object object4 = it.key;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it.key");
                object3[0] = (String)object4;
                object3 = CollectionsKt.mutableListOf((Object[])object3);
                object.put(object2, object3);
                continue;
            }
            object = it.key;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.key");
            bucket.add(0, (String)object);
        }
    }

    private void populateBucketPriority() {
        Map<Integer, List<String>> $this$forEach$iv = this.v1orderToTemplatesName;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, List<String>> element$iv;
            Map.Entry<Integer, List<String>> $dstr$order$templateNames = element$iv = iterator.next();
            boolean bl = false;
            int order = ((Number)$dstr$order$templateNames.getKey()).intValue();
            List<String> templateNames = $dstr$order$templateNames.getValue();
            int increase = 0;
            Iterable $this$forEach$iv2 = templateNames;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                V1TemplateCache v1TemplateCache = this.v1TemplatesWithPolicyID.get(it);
                if (v1TemplateCache != null) {
                    int cachePriority = v1TemplateCache.getOrder();
                    Map<String, V1TemplateCache> map = this.v1TemplatesWithPolicyID;
                    V1TemplateCache v1TemplateCache2 = V1TemplateCache.copy$default(v1TemplateCache, null, cachePriority + increase, null, 5, null);
                    map.put(it, v1TemplateCache2);
                }
                int n = increase;
                increase = n + 1;
            }
            Map<Integer, Integer> map = this.v1orderToBucketIncrement;
            Integer n = order;
            Integer n2 = templateNames.size() - 1;
            map.put(n, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populateV1Template() {
        List allOrders = CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)this.v1orderToTemplatesName.keySet()));
        Iterable $this$forEachIndexed$iv = allOrders;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void order;
            List<String> templates;
            void $this$mapNotNullTo$iv$iv;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int ind = n;
            boolean bl = false;
            List smallerOrders = allOrders.subList(0, ind);
            Iterable $this$mapNotNull$iv = smallerOrders;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl3 = false;
                if (this.v1orderToBucketIncrement.get(it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            int increments = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            List<String> list = templates = this.v1orderToTemplatesName.get((int)order);
            if (list == null) continue;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                V1TemplateCache v1TemplateCache = this.v1TemplatesWithPolicyID.get(it);
                if (v1TemplateCache == null) continue;
                String policyID = v1TemplateCache.getPolicyID();
                List<String> indexPatterns = v1TemplateCache.getPatterns();
                int priority = v1TemplateCache.getOrder() + increments;
                Instant instant = this.lastUpdatedTime;
                if (instant == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastUpdatedTime");
                    instant = null;
                }
                this.saveISMTemplateToMap(policyID, new ISMTemplate(indexPatterns, priority, instant));
            }
        }
    }

    private void saveISMTemplateToMap(String policyID, ISMTemplate ismTemplate) {
        List<ISMTemplate> policyToISMTemplate = this.ismTemplateMap.get(policyID);
        if (policyToISMTemplate != null) {
            policyToISMTemplate.add(ismTemplate);
        } else {
            Map<String, List<ISMTemplate>> map = this.ismTemplateMap;
            Object object = new ISMTemplate[]{ismTemplate};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(policyID, (List<ISMTemplate>)object);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object simulateTemplate(String var1_1, Continuation<? super String> var2_2) {
        if (!(var2_2 instanceof simulateTemplate.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ISMTemplateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ISMTemplateService.access$simulateTemplate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = new SimulateTemplateAction.Request((String)templateName);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<Client, ActionListener<SimulateIndexTemplateResponse>, Unit>(request){
                    final /* synthetic */ SimulateTemplateAction.Request $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SimulateIndexTemplateResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.execute((ActionType)SimulateTemplateAction.INSTANCE, (ActionRequest)this.$request, it);
                    }
                }, $continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                response = (SimulateIndexTemplateResponse)v0;
                policyIDSetting = new Ref.ObjectRef();
                $continuation.L$0 = policyIDSetting;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)policyIDSetting, response, null){
                    int label;
                    final /* synthetic */ Ref.ObjectRef<String> $policyIDSetting;
                    final /* synthetic */ SimulateIndexTemplateResponse $response;
                    {
                        this.$policyIDSetting = $policyIDSetting;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                BytesStreamOutput bytesStreamOutput = new BytesStreamOutput();
                                SimulateIndexTemplateResponse simulateIndexTemplateResponse = this.$response;
                                BytesStreamOutput it = bytesStreamOutput;
                                boolean bl = false;
                                simulateIndexTemplateResponse.writeTo((StreamOutput)it);
                                BytesStreamOutput out = bytesStreamOutput;
                                StreamInput sin = StreamInput.wrap((byte[])out.bytes().toBytesRef().bytes);
                                Template resolvedTemplate = (Template)sin.readOptionalWriteable(Template::new);
                                if (resolvedTemplate != null) {
                                    this.$policyIDSetting.element = ManagedIndexSettings.Companion.getPOLICY_ID().get(resolvedTemplate.settings());
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                policyIDSetting = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                return policyIDSetting.element;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private void populateV2ISMTemplateMap(String policyID, List<String> indexPatterns, int priority) {
        int v1Increment = 0;
        Integer v1MaxOrder = (Integer)CollectionsKt.maxOrNull((Iterable)this.v1orderToBucketIncrement.keySet());
        if (v1MaxOrder != null) {
            v1Increment = v1MaxOrder + CollectionsKt.sumOfInt((Iterable)this.v1orderToBucketIncrement.values());
        }
        int n = this.normalizePriority(priority) + v1Increment;
        Instant instant = this.lastUpdatedTime;
        if (instant == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastUpdatedTime");
            instant = null;
        }
        this.saveISMTemplateToMap(policyID, new ISMTemplate(indexPatterns, n, instant));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object getISMPolicies(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof getISMPolicies.1)) ** GOTO lbl-1000
        var18_2 = var1_1;
        if ((var18_2.label & -2147483648) != 0) {
            var18_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ISMTemplateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ISMTemplateService.access$getISMPolicies(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.ismTemplateMap.isEmpty()) {
                    return Unit.INSTANCE;
                }
                mReq = new MultiGetRequest();
                $this$forEach$iv = this.ismTemplateMap.keySet();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    $i$a$-forEach-ISMTemplateService$getISMPolicies$2 = false;
                    mReq.add(".opendistro-ism-config", it);
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)new Function2<Client, ActionListener<MultiGetResponse>, Unit>(mReq){
                    final /* synthetic */ MultiGetRequest $mReq;
                    {
                        this.$mReq = $mReq;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<MultiGetResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.multiGet(this.$mReq, it);
                    }
                }, $continuation);
                ** if (v0 != var19_4) goto lbl30
lbl29:
                // 1 sources

                return var19_4;
lbl30:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                this = (ISMTemplateService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl37:
                    // 2 sources

                    mRes = (MultiGetResponse)v0;
                    this.policiesToUpdate.clear();
                    $this$forEach$iv = (Iterable)mRes;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (MultiGetItemResponse)element$iv;
                        $i$a$-forEach-ISMTemplateService$getISMPolicies$3 = false;
                        if (it.getResponse() == null || it.getResponse().isSourceEmpty() || it.isFailed()) continue;
                        response = it.getResponse();
                        policy = null;
                        try {
                            var12_19 = (Closeable)XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response.getSourceAsBytesRef(), (XContentType)XContentType.JSON);
                            var13_21 = null;
                            try {
                                xcp = (XContentParser)var12_19;
                                $i$a$-use-ISMTemplateService$getISMPolicies$3$1 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                                var16_26 = response.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)var16_26, (String)"response.id");
                                var14_22 = (Policy)OpenSearchExtensionsKt.parseWithType(xcp, var16_26, response.getSeqNo(), response.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                                    @NotNull
                                    public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                        return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                                    }
                                });
                            }
                            catch (Throwable var14_23) {
                                var13_21 = var14_23;
                                throw var14_23;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var12_19, (Throwable)var13_21);
                            }
                            policy = var14_22;
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to parse policy [" + response.getId() + "] when migrating templates", (Throwable)e);
                        }
                        v1 = policy;
                        if ((v1 == null ? null : v1.getIsmTemplate()) != null) continue;
                        var13_21 = it.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)var13_21, (String)"it.id");
                        this.policiesToUpdate.put((String)var13_21, (Pair<Long, Long>)new Pair((Object)Boxing.boxLong((long)response.getSeqNo()), (Object)Boxing.boxLong((long)response.getPrimaryTerm())));
                    }
                }
                catch (ActionRequestValidationException var3_7) {
                    this.logger.warn("ISM config index not exists when migrating templates.");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private Object updateISMPolicies(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof updateISMPolicies.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ISMTemplateService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ISMTemplateService.access$updateISMPolicies(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.policiesToUpdate.isEmpty()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.imIndices.attemptUpdateConfigIndexMapping((Continuation<? super Boolean>)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (ISMTemplateService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.logger.error("Failed to update config index mapping.");
                    return Unit.INSTANCE;
                }
                requests = new Ref.ObjectRef();
                requests.element = new ArrayList<E>();
                this.policiesToUpdate.forEach((BiConsumer<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, updateISMPolicies$lambda-11(org.opensearch.indexmanagement.migration.ISMTemplateService kotlin.jvm.internal.Ref$ObjectRef java.lang.String kotlin.Pair ), (Ljava/lang/String;Lkotlin/Pair;)V)((ISMTemplateService)this, (Ref.ObjectRef)requests));
                var3_6 = this.retryPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"retryPolicy");
                v1 = var3_6;
                var3_6 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var3_6, (String)"logger");
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = OpenSearchExtensionsKt.retry(v1, (Logger)var3_6, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>((Ref.ObjectRef<List<UpdateRequest>>)requests, this, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int label;
                    final /* synthetic */ Ref.ObjectRef<List<UpdateRequest>> $requests;
                    final /* synthetic */ ISMTemplateService this$0;
                    {
                        this.$requests = $requests;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                failedRequests = new ArrayList<E>();
                                retryCause = new Ref.ObjectRef();
                                var4_5 = (Iterable)this.$requests.element;
                                var5_6 = this.this$0;
                                $i$f$forEach = false;
                                var7_8 = $this$forEach$iv.iterator();
lbl11:
                                // 5 sources

                                while (var7_8.hasNext()) {
                                    element$iv = var7_8.next();
                                    req = (UpdateRequest)element$iv;
                                    $i$a$-forEach-ISMTemplateService$updateISMPolicies$3$1 = false;
                                    res = null;
                                    this.L$0 = failedRequests;
                                    this.L$1 = retryCause;
                                    this.L$2 = var5_6;
                                    this.L$3 = var7_8;
                                    this.L$4 = req;
                                    this.label = 1;
                                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)ISMTemplateService.access$getClient$p(var5_6), (Function2)new Function2<Client, ActionListener<UpdateResponse>, Unit>(req){
                                        final /* synthetic */ UpdateRequest $req;
                                        {
                                            this.$req = $req;
                                            super(2);
                                        }

                                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<UpdateResponse> it) {
                                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                            Intrinsics.checkNotNullParameter(it, (String)"it");
                                            $this$suspendUntil.update(this.$req, it);
                                        }
                                    }, this);
                                    ** if (v0 != var13_2) goto lbl27
lbl26:
                                    // 1 sources

                                    return var13_2;
lbl27:
                                    // 1 sources

                                    ** GOTO lbl42
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-ISMTemplateService$updateISMPolicies$3$1 = false;
                                res = null;
                                req = (UpdateRequest)this.L$4;
                                var7_8 = (Iterator<T>)this.L$3;
                                var5_6 = (ISMTemplateService)this.L$2;
                                retryCause = (Ref.ObjectRef)this.L$1;
                                failedRequests = (List)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl42:
                                    // 2 sources

                                    res = (UpdateResponse)v0;
                                    ISMTemplateService.access$getLogger$p(var5_6).info("update policy for " + req.id());
                                    v1 = res;
                                    if ((v1 == null ? null : v1.getResult()) != DocWriteResponse.Result.UPDATED) ** GOTO lbl11
                                    ISMTemplateService.access$getPoliciesToUpdate$p(var5_6).remove(req.id());
                                }
                                catch (Exception e) {
                                    ISMTemplateService.access$getLogger$p(var5_6).info("failed to update policy for " + req.id());
                                    v2 = res;
                                    if ((v2 == null ? null : v2.status()) != RestStatus.TOO_MANY_REQUESTS) ** GOTO lbl57
                                    failedRequests.add(req);
                                    retryCause.element = e;
                                    ** GOTO lbl11
lbl57:
                                    // 1 sources

                                    ISMTemplateService.access$getLogger$p(var5_6).error("Failed to update policy " + req.id() + " with ISM template", (Throwable)e);
                                }
                                ** GOTO lbl11
                            }
                        }
                        if (((Collection)failedRequests).isEmpty() == false) {
                            this.$requests.element = failedRequests;
                            var4_5 = ExceptionsHelper.convertToOpenSearchException((Exception)((Exception)retryCause.element));
                            Intrinsics.checkNotNullExpressionValue((Object)var4_5, (String)"convertToOpenSearchException(retryCause)");
                            throw (Throwable)var4_5;
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                if (v2 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private void cleanCache() {
        this.ismTemplateMap.clear();
        this.v1TemplatesWithPolicyID.clear();
        this.v1orderToTemplatesName.clear();
        this.v1orderToBucketIncrement.clear();
        this.negOrderToPositive.clear();
        this.policiesToUpdate.clear();
    }

    private static final void updateISMPolicies$lambda-11(ISMTemplateService this$0, Ref.ObjectRef $requests, String policyID, Pair $dstr$seqNo$priTerm) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requests, (String)"$requests");
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        Intrinsics.checkNotNullParameter((Object)$dstr$seqNo$priTerm, (String)"$dstr$seqNo$priTerm");
        long seqNo = ((Number)$dstr$seqNo$priTerm.component1()).longValue();
        long priTerm = ((Number)$dstr$seqNo$priTerm.component2()).longValue();
        List<ISMTemplate> ismTemplates = this$0.ismTemplateMap.get(policyID);
        if (ismTemplates != null) {
            ((List)$requests.element).add(ManagedIndexUtils.updateISMTemplateRequest(policyID, ismTemplates, seqNo, priTerm));
        }
    }

    public static final /* synthetic */ Logger access$getLogger$p(ISMTemplateService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$getIndexTemplates(ISMTemplateService $this, Continuation $completion) {
        return $this.getIndexTemplates((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$simulateTemplate(ISMTemplateService $this, String templateName, Continuation $completion) {
        return $this.simulateTemplate(templateName, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$getISMPolicies(ISMTemplateService $this, Continuation $completion) {
        return $this.getISMPolicies((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$updateISMPolicies(ISMTemplateService $this, Continuation $completion) {
        return $this.updateISMPolicies((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Client access$getClient$p(ISMTemplateService $this) {
        return $this.client;
    }

    public static final /* synthetic */ Map access$getPoliciesToUpdate$p(ISMTemplateService $this) {
        return $this.policiesToUpdate;
    }
}

