/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.util;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.indexstatemanagement.action.RolloverAction;
import org.opensearch.indexmanagement.indexstatemanagement.model.ChangePolicy;
import org.opensearch.indexmanagement.indexstatemanagement.model.Conditions;
import org.opensearch.indexmanagement.indexstatemanagement.model.ISMTemplate;
import org.opensearch.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.model.State;
import org.opensearch.indexmanagement.indexstatemanagement.model.Transition;
import org.opensearch.indexmanagement.indexstatemanagement.model.coordinator.SweptManagedIndexConfig;
import org.opensearch.indexmanagement.indexstatemanagement.util.MetadataCheck;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionRetry;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionTimeout;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.PolicyRetryInfoMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StateMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00dc\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a,\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001\u001a(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a\u0006\u0010\u0018\u001a\u00020\u0019\u001aA\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&\u001a\u000e\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001\u001a\"\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020\u0003\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001\u001a\u000e\u0010/\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u000e\u00101\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u0001\u001a'\u00102\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u000105H\u0002\u00a2\u0006\u0002\u00106\u001a,\u00107\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u00012\f\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00152\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205\u001a\u000e\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020>\u001a*\u0010?\u001a\u00020\u0003*\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u0002052\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020E\u001a=\u0010?\u001a\u00020\u0003*\u00020G2\u0006\u0010H\u001a\u00020I2\b\u0010C\u001a\u0004\u0018\u0001052\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010J\u001a\u00020I2\b\u0010K\u001a\u0004\u0018\u00010I\u00a2\u0006\u0002\u0010L\u001a\u001a\u0010M\u001a\u00020\u0004*\u00020\u00042\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q\u001a(\u0010R\u001a\u00020\u0004*\u00020\u00042\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010N\u001a\u0004\u0018\u00010O2\b\u0010P\u001a\u0004\u0018\u00010Q\u001a\u0012\u0010U\u001a\u00020V*\u00020T2\u0006\u0010W\u001a\u00020\u0004\u001a\u0012\u0010X\u001a\u00020\u0003*\u00020&2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\n\u0010Y\u001a\u00020\u0003*\u00020G\u001a\u0014\u0010Z\u001a\u00020\u0003*\u00020O2\b\u0010[\u001a\u0004\u0018\u00010\\\u001a\u0012\u0010]\u001a\u00020\u0003*\u00020\u00042\u0006\u0010%\u001a\u00020&\u001a\u0018\u0010^\u001a\u00020\u0003*\u00020O2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u001a$\u0010`\u001a\u00020\u0003*\u00020!2\b\u0010a\u001a\u0004\u0018\u00010\u00012\u0006\u0010b\u001a\u00020!2\u0006\u0010c\u001a\u00020d\u001a.\u0010e\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u000105\u0018\u00010f*\u00020O2\b\u0010[\u001a\u0004\u0018\u00010\\2\b\u0010g\u001a\u0004\u0018\u00010h\u001a\u001c\u0010i\u001a\u00020\u0003*\u00020&2\u0006\u0010W\u001a\u00020\u00042\b\u0010j\u001a\u0004\u0018\u00010O\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006k"}, d2={"METADATA_POST_FIX", "", "isFailed", "", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;)Z", "isPolicyCompleted", "isSuccessfulDelete", "checkMetadata", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/MetadataCheck;", "clusterStateMetadata", "configIndexMetadata", "", "currentIndexUuid", "logger", "Lorg/apache/logging/log4j/Logger;", "deleteManagedIndexMetadataRequest", "Lorg/opensearch/action/delete/DeleteRequest;", "uuid", "deleteManagedIndexRequest", "getManagedIndicesToDelete", "", "currentIndexUuids", "currentManagedIndexUuids", "getSweptManagedIndexSearchRequest", "Lorg/opensearch/action/search/SearchRequest;", "managedIndexConfigIndexRequest", "Lorg/opensearch/action/index/IndexRequest;", "index", "policyID", "jobInterval", "", "policy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;", "jobJitter", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILorg/opensearch/indexmanagement/indexstatemanagement/model/Policy;Ljava/lang/Double;)Lorg/opensearch/action/index/IndexRequest;", "managedIndexConfig", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ManagedIndexConfig;", "managedIndexMetadataID", "indexUuid", "managedIndexMetadataIndexRequest", "managedIndexMetadata", "waitRefresh", "create", "revertManagedIndexMetadataID", "metadataID", "updateDisableManagedIndexRequest", "Lorg/opensearch/action/update/UpdateRequest;", "updateEnableManagedIndexRequest", "updateEnabledField", "enabled", "enabledTime", "", "(Ljava/lang/String;ZLjava/lang/Long;)Lorg/opensearch/action/update/UpdateRequest;", "updateISMTemplateRequest", "ismTemplates", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ISMTemplate;", "seqNo", "primaryTerm", "updateManagedIndexRequest", "sweptManagedIndexConfig", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/coordinator/SweptManagedIndexConfig;", "evaluateConditions", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/RolloverAction;", "indexAgeTimeValue", "Lorg/opensearch/common/unit/TimeValue;", "numDocs", "indexSize", "Lorg/opensearch/common/unit/ByteSizeValue;", "primaryShardSize", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/Transition;", "indexCreationDate", "Ljava/time/Instant;", "transitionStartTime", "rolloverDate", "(Lorg/opensearch/indexmanagement/indexstatemanagement/model/Transition;Ljava/time/Instant;Ljava/lang/Long;Lorg/opensearch/common/unit/ByteSizeValue;Ljava/time/Instant;Ljava/time/Instant;)Z", "getCompletedManagedIndexMetaData", "action", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "step", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "getStartingManagedIndexMetaData", "state", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/State;", "getUpdatedStateMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StateMetaData;", "managedIndexMetaData", "hasDifferentJobInterval", "hasStatsConditions", "hasTimedOut", "actionMetaData", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionMetaData;", "hasVersionConflict", "isAllowed", "allowList", "isSafeToChange", "stateName", "newPolicy", "changePolicy", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/ChangePolicy;", "shouldBackoff", "Lkotlin/Pair;", "actionRetry", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ActionRetry;", "shouldChangePolicy", "actionToExecute", "opensearch-index-management"})
@JvmName(name="ManagedIndexUtils")
public final class ManagedIndexUtils {
    @NotNull
    public static final String METADATA_POST_FIX = "#metadata";

    @NotNull
    public static final IndexRequest managedIndexConfigIndexRequest(@NotNull String index2, @NotNull String uuid, @NotNull String policyID, int jobInterval, @Nullable Policy policy2, @Nullable Double jobJitter) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        IntervalSchedule intervalSchedule = new IntervalSchedule(Instant.now(), jobInterval, ChronoUnit.MINUTES);
        Instant instant = Instant.now();
        Instant instant2 = Instant.now();
        Policy policy3 = policy2;
        Long l = policy3 == null ? null : Long.valueOf(policy3.getSeqNo());
        Policy policy4 = policy2;
        Long l2 = policy4 == null ? null : Long.valueOf(policy4.getPrimaryTerm());
        Schedule schedule = (Schedule)intervalSchedule;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        ManagedIndexConfig managedIndexConfig = new ManagedIndexConfig(null, 0L, 0L, index2, index2, uuid, true, schedule, instant, instant2, policyID, l, l2, policy2, null, jobJitter, 7, null);
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(uuid).create(true).routing(managedIndexConfig.getIndexUuid());
        instant = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"jsonBuilder()");
        Instant instant3 = instant;
        instant = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"EMPTY_PARAMS");
        intervalSchedule = indexRequest.source(managedIndexConfig.toXContent((XContentBuilder)instant3, (ToXContent.Params)instant));
        Intrinsics.checkNotNullExpressionValue((Object)intervalSchedule, (String)"IndexRequest(INDEX_MANAG\u2026ToXContent.EMPTY_PARAMS))");
        return intervalSchedule;
    }

    public static /* synthetic */ IndexRequest managedIndexConfigIndexRequest$default(String string, String string2, String string3, int n, Policy policy2, Double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            policy2 = null;
        }
        return ManagedIndexUtils.managedIndexConfigIndexRequest(string, string2, string3, n, policy2, d);
    }

    @NotNull
    public static final IndexRequest managedIndexConfigIndexRequest(@NotNull ManagedIndexConfig managedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)managedIndexConfig, (String)"managedIndexConfig");
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(managedIndexConfig.getIndexUuid()).setIfPrimaryTerm(managedIndexConfig.getPrimaryTerm()).setIfSeqNo(managedIndexConfig.getSeqNo()).routing(managedIndexConfig.getIndexUuid());
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        XContentBuilder xContentBuilder2 = xContentBuilder;
        xContentBuilder = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"EMPTY_PARAMS");
        IndexRequest indexRequest2 = indexRequest.source(managedIndexConfig.toXContent(xContentBuilder2, (ToXContent.Params)xContentBuilder));
        Intrinsics.checkNotNullExpressionValue((Object)indexRequest2, (String)"IndexRequest(INDEX_MANAG\u2026ToXContent.EMPTY_PARAMS))");
        return indexRequest2;
    }

    @NotNull
    public static final String managedIndexMetadataID(@NotNull String indexUuid) {
        Intrinsics.checkNotNullParameter((Object)indexUuid, (String)"indexUuid");
        return indexUuid + METADATA_POST_FIX;
    }

    @NotNull
    public static final String revertManagedIndexMetadataID(@NotNull String metadataID) {
        Intrinsics.checkNotNullParameter((Object)metadataID, (String)"metadataID");
        return StringsKt.dropLast((String)metadataID, (int)METADATA_POST_FIX.length());
    }

    @NotNull
    public static final IndexRequest managedIndexMetadataIndexRequest(@NotNull ManagedIndexMetaData managedIndexMetadata, boolean waitRefresh, boolean create) {
        Intrinsics.checkNotNullParameter((Object)managedIndexMetadata, (String)"managedIndexMetadata");
        IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").id(ManagedIndexUtils.managedIndexMetadataID(managedIndexMetadata.getIndexUuid())).setIfPrimaryTerm(managedIndexMetadata.getPrimaryTerm()).setIfSeqNo(managedIndexMetadata.getSeqNo()).routing(managedIndexMetadata.getIndexUuid()).create(create);
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        XContentBuilder xContentBuilder2 = xContentBuilder;
        xContentBuilder = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"EMPTY_PARAMS");
        IndexRequest req = indexRequest.source(managedIndexMetadata.toXContent(xContentBuilder2, (ToXContent.Params)xContentBuilder, true));
        if (waitRefresh) {
            xContentBuilder = req.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"req.setRefreshPolicy(Wri\u2026RefreshPolicy.WAIT_UNTIL)");
            return (IndexRequest)xContentBuilder;
        }
        Intrinsics.checkNotNullExpressionValue((Object)req, (String)"req");
        return req;
    }

    public static /* synthetic */ IndexRequest managedIndexMetadataIndexRequest$default(ManagedIndexMetaData managedIndexMetaData, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return ManagedIndexUtils.managedIndexMetadataIndexRequest(managedIndexMetaData, bl, bl2);
    }

    private static final UpdateRequest updateEnabledField(String uuid, boolean enabled, Long enabledTime) {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("managed_index");
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()\n        .s\u2026onfig.MANAGED_INDEX_TYPE)");
        XContentBuilder builder = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, "last_updated_time", Instant.now()).field("enabled", enabled).field("enabled_time", enabledTime).endObject().endObject();
        xContentBuilder = new UpdateRequest(".opendistro-ism-config", uuid).doc(builder);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"UpdateRequest(INDEX_MANA\u2026INDEX, uuid).doc(builder)");
        return xContentBuilder;
    }

    @NotNull
    public static final UpdateRequest updateISMTemplateRequest(@NotNull String policyID, @NotNull List<ISMTemplate> ismTemplates, long seqNo, long primaryTerm) {
        Intrinsics.checkNotNullParameter((Object)policyID, (String)"policyID");
        Intrinsics.checkNotNullParameter(ismTemplates, (String)"ismTemplates");
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().startObject().startObject("policy");
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()\n        .s\u2026bject(Policy.POLICY_TYPE)");
        XContentBuilder builder = OpenSearchExtensionsKt.optionalISMTemplateField(xContentBuilder, "ism_template", ismTemplates).endObject().endObject();
        xContentBuilder = new UpdateRequest(".opendistro-ism-config", policyID).doc(builder).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"UpdateRequest(INDEX_MANA\u2026fPrimaryTerm(primaryTerm)");
        return xContentBuilder;
    }

    @NotNull
    public static final UpdateRequest updateDisableManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return ManagedIndexUtils.updateEnabledField(uuid, false, null);
    }

    @NotNull
    public static final UpdateRequest updateEnableManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return ManagedIndexUtils.updateEnabledField(uuid, true, Instant.now().toEpochMilli());
    }

    @NotNull
    public static final DeleteRequest deleteManagedIndexRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return new DeleteRequest(".opendistro-ism-config", uuid);
    }

    @NotNull
    public static final DeleteRequest deleteManagedIndexMetadataRequest(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        DeleteRequest deleteRequest = new DeleteRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)deleteRequest, (String)"DeleteRequest(INDEX_MANA\u2026taID(uuid)).routing(uuid)");
        return deleteRequest;
    }

    @NotNull
    public static final UpdateRequest updateManagedIndexRequest(@NotNull SweptManagedIndexConfig sweptManagedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)sweptManagedIndexConfig, (String)"sweptManagedIndexConfig");
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", sweptManagedIndexConfig.getUuid()).setIfPrimaryTerm(sweptManagedIndexConfig.getPrimaryTerm()).setIfSeqNo(sweptManagedIndexConfig.getSeqNo()).doc(RestHandlerUtilsKt.getPartialChangePolicyBuilder(sweptManagedIndexConfig.getChangePolicy()));
        Intrinsics.checkNotNullExpressionValue((Object)updateRequest, (String)"UpdateRequest(INDEX_MANA\u2026ndexConfig.changePolicy))");
        return updateRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getManagedIndicesToDelete(@NotNull List<String> currentIndexUuids, @NotNull List<String> currentManagedIndexUuids) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(currentIndexUuids, (String)"currentIndexUuids");
        Intrinsics.checkNotNullParameter(currentManagedIndexUuids, (String)"currentManagedIndexUuids");
        Iterable $this$filter$iv = currentManagedIndexUuids;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String currentManagedIndex = (String)element$iv$iv;
            boolean bl = false;
            if (!(!currentIndexUuids.contains(currentManagedIndex))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final SearchRequest getSweptManagedIndexSearchRequest() {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.existsQuery((String)"managed_index"));
        String[] stringArray = new String[]{".opendistro-ism-config"};
        boolean $i$f$emptyArray = false;
        $i$f$emptyArray = false;
        SearchRequest searchRequest = new SearchRequest().indices(stringArray).scroll(TimeValue.timeValueMinutes((long)1L)).source(SearchSourceBuilder.searchSource().size(10000).seqNoAndPrimaryTerm(Boolean.valueOf(true)).fetchSource(new String[0], new String[0]).query((QueryBuilder)boolQueryBuilder));
        Intrinsics.checkNotNullExpressionValue((Object)searchRequest, (String)"SearchRequest()\n        \u2026olQueryBuilder)\n        )");
        return searchRequest;
    }

    public static final boolean evaluateConditions(@NotNull Transition $this$evaluateConditions, @NotNull Instant indexCreationDate, @Nullable Long numDocs, @Nullable ByteSizeValue indexSize, @NotNull Instant transitionStartTime, @Nullable Instant rolloverDate) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluateConditions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indexCreationDate, (String)"indexCreationDate");
        Intrinsics.checkNotNullParameter((Object)transitionStartTime, (String)"transitionStartTime");
        if ($this$evaluateConditions.getConditions() == null) {
            return true;
        }
        if ($this$evaluateConditions.getConditions().getDocCount() != null && numDocs != null) {
            return $this$evaluateConditions.getConditions().getDocCount() <= numDocs;
        }
        if ($this$evaluateConditions.getConditions().getIndexAge() != null) {
            long indexCreationDateMilli = indexCreationDate.toEpochMilli();
            if (indexCreationDateMilli == -1L) {
                return false;
            }
            long elapsedTime = Instant.now().toEpochMilli() - indexCreationDateMilli;
            return $this$evaluateConditions.getConditions().getIndexAge().getMillis() <= elapsedTime;
        }
        if ($this$evaluateConditions.getConditions().getSize() != null && indexSize != null) {
            return $this$evaluateConditions.getConditions().getSize().compareTo(indexSize) <= 0;
        }
        if ($this$evaluateConditions.getConditions().getCron() != null) {
            return $this$evaluateConditions.getConditions().getCron().getNextExecutionTime(transitionStartTime).compareTo(Instant.now()) <= 0;
        }
        if ($this$evaluateConditions.getConditions().getRolloverAge() != null) {
            Instant instant = rolloverDate;
            Long l = instant == null ? null : Long.valueOf(instant.toEpochMilli());
            if (l == null) {
                return false;
            }
            long rolloverDateMilli = l;
            long elapsedTime = Instant.now().toEpochMilli() - rolloverDateMilli;
            return $this$evaluateConditions.getConditions().getRolloverAge().getMillis() <= elapsedTime;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasStatsConditions(@NotNull Transition $this$hasStatsConditions) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStatsConditions, (String)"<this>");
        Conditions conditions = $this$hasStatsConditions.getConditions();
        if ((conditions == null ? null : conditions.getDocCount()) != null) return true;
        Conditions conditions2 = $this$hasStatsConditions.getConditions();
        if (conditions2 == null) {
            return false;
        }
        ByteSizeValue byteSizeValue = conditions2.getSize();
        if (byteSizeValue == null) return false;
        return true;
    }

    public static final boolean evaluateConditions(@NotNull RolloverAction $this$evaluateConditions, @NotNull TimeValue indexAgeTimeValue, long numDocs, @NotNull ByteSizeValue indexSize, @NotNull ByteSizeValue primaryShardSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$evaluateConditions), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indexAgeTimeValue, (String)"indexAgeTimeValue");
        Intrinsics.checkNotNullParameter((Object)indexSize, (String)"indexSize");
        Intrinsics.checkNotNullParameter((Object)primaryShardSize, (String)"primaryShardSize");
        if ($this$evaluateConditions.getMinDocs() == null && $this$evaluateConditions.getMinAge() == null && $this$evaluateConditions.getMinSize() == null && $this$evaluateConditions.getMinPrimaryShardSize() == null) {
            return true;
        }
        if ($this$evaluateConditions.getMinDocs() != null && $this$evaluateConditions.getMinDocs() <= numDocs) {
            return true;
        }
        if ($this$evaluateConditions.getMinAge() != null && $this$evaluateConditions.getMinAge().getMillis() <= indexAgeTimeValue.getMillis()) {
            return true;
        }
        if ($this$evaluateConditions.getMinSize() != null && $this$evaluateConditions.getMinSize().compareTo(indexSize) <= 0) {
            return true;
        }
        return $this$evaluateConditions.getMinPrimaryShardSize() != null && $this$evaluateConditions.getMinPrimaryShardSize().compareTo(primaryShardSize) <= 0;
    }

    @NotNull
    public static final StateMetaData getUpdatedStateMetaData(@NotNull State $this$getUpdatedStateMetaData, @NotNull ManagedIndexMetaData managedIndexMetaData) {
        Intrinsics.checkNotNullParameter((Object)$this$getUpdatedStateMetaData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
        return stateMetaData == null ? new StateMetaData($this$getUpdatedStateMetaData.getName(), Instant.now().toEpochMilli()) : (!Intrinsics.areEqual((Object)stateMetaData.getName(), (Object)$this$getUpdatedStateMetaData.getName()) ? new StateMetaData($this$getUpdatedStateMetaData.getName(), Instant.now().toEpochMilli()) : stateMetaData);
    }

    @Nullable
    public static final Pair<Boolean, Long> shouldBackoff(@NotNull Action $this$shouldBackoff, @Nullable ActionMetaData actionMetaData, @Nullable ActionRetry actionRetry) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$shouldBackoff, (String)"<this>");
        ActionRetry actionRetry2 = $this$shouldBackoff.getConfigRetry();
        if (actionRetry2 == null) {
            pair = null;
        } else {
            ActionRetry.Backoff backoff = actionRetry2.getBackoff();
            pair = backoff == null ? null : backoff.shouldBackoff(actionMetaData, actionRetry);
        }
        return pair;
    }

    public static final boolean hasTimedOut(@NotNull Action $this$hasTimedOut, @Nullable ActionMetaData actionMetaData) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTimedOut, (String)"<this>");
        ActionMetaData actionMetaData2 = actionMetaData;
        Long startTime = actionMetaData2 == null ? null : actionMetaData2.getStartTime();
        ActionTimeout configTimeout = $this$hasTimedOut.getConfigTimeout();
        if (startTime == null || configTimeout == null) {
            return false;
        }
        return Instant.now().toEpochMilli() - startTime > configTimeout.getTimeout().getMillis();
    }

    @NotNull
    public static final ManagedIndexMetaData getStartingManagedIndexMetaData(@NotNull ManagedIndexMetaData $this$getStartingManagedIndexMetaData, @Nullable State state, @Nullable Action action, @Nullable Step step) {
        Intrinsics.checkNotNullParameter((Object)$this$getStartingManagedIndexMetaData, (String)"<this>");
        if (state == null) {
            PolicyRetryInfoMetaData policyRetryInfoMetaData = new PolicyRetryInfoMetaData(true, 0);
            String string = $this$getStartingManagedIndexMetaData.getTransitionTo();
            if (string == null) {
                string = $this$getStartingManagedIndexMetaData.getStateMetaData();
            }
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)policyRetryInfoMetaData, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Failed to find state=" + string + " in policy=" + $this$getStartingManagedIndexMetaData.getPolicyID()))), null, (long)0L, (long)0L, (int)118783, null);
        }
        if (action == null || step == null) {
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)new PolicyRetryInfoMetaData(true, 0), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Failed to find action=" + $this$getStartingManagedIndexMetaData.getActionMetaData() + " in state=" + $this$getStartingManagedIndexMetaData.getStateMetaData()))), null, (long)0L, (long)0L, (int)118783, null);
        }
        StateMetaData updatedStateMetaData = ManagedIndexUtils.getUpdatedStateMetaData(state, $this$getStartingManagedIndexMetaData);
        ActionMetaData updatedActionMetaData = action.getUpdatedActionMetadata($this$getStartingManagedIndexMetaData, state.getName());
        StepMetaData updatedStepMetaData = step.getStartingStepMetaData($this$getStartingManagedIndexMetaData);
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getStartingManagedIndexMetaData, null, null, null, null, null, null, null, null, null, (StateMetaData)updatedStateMetaData, (ActionMetaData)updatedActionMetaData, (StepMetaData)updatedStepMetaData, null, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Starting action " + action.getType() + " and working on " + step.getName()))), null, (long)0L, (long)0L, (int)119295, null);
    }

    @NotNull
    public static final ManagedIndexMetaData getCompletedManagedIndexMetaData(@NotNull ManagedIndexMetaData $this$getCompletedManagedIndexMetaData, @NotNull Action action, @NotNull Step step) {
        ActionMetaData actionMetaData;
        Intrinsics.checkNotNullParameter((Object)$this$getCompletedManagedIndexMetaData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        ManagedIndexMetaData updatedStepMetaData = step.getUpdatedManagedIndexMetadata($this$getCompletedManagedIndexMetaData);
        ActionMetaData actionMetaData2 = updatedStepMetaData.getActionMetaData();
        if (actionMetaData2 == null) {
            return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getCompletedManagedIndexMetaData, null, null, null, null, null, null, null, null, null, null, null, null, (PolicyRetryInfoMetaData)new PolicyRetryInfoMetaData(true, 0), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"Failed due to ActionMetaData being null")), null, (long)0L, (long)0L, (int)118783, null);
        }
        ActionMetaData actionMetaData3 = actionMetaData2;
        StepMetaData stepMetaData = updatedStepMetaData.getStepMetaData();
        if ((stepMetaData == null ? null : stepMetaData.getStepStatus()) == Step.StepStatus.FAILED) {
            if (action.getConfigRetry() == null) {
                actionMetaData = ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)true, (int)0, null, null, (int)119, null);
            } else {
                long l = actionMetaData3.getConsumedRetries();
                ActionRetry actionRetry = action.getConfigRetry();
                Intrinsics.checkNotNull((Object)actionRetry);
                actionMetaData = l >= actionRetry.getCount() ? ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)true, (int)0, null, null, (int)119, null) : ActionMetaData.copy$default((ActionMetaData)actionMetaData3, null, null, (int)0, (boolean)false, (int)(actionMetaData3.getConsumedRetries() + 1), (Long)Instant.now().toEpochMilli(), null, (int)71, null);
            }
        } else {
            actionMetaData = actionMetaData3;
        }
        ActionMetaData updatedActionMetaData = actionMetaData;
        Boolean bl = updatedStepMetaData.getPolicyCompleted();
        Boolean bl2 = updatedStepMetaData.getRolledOver();
        StepMetaData stepMetaData2 = updatedStepMetaData.getStepMetaData();
        String string = updatedStepMetaData.getTransitionTo();
        PolicyRetryInfoMetaData policyRetryInfoMetaData = updatedStepMetaData.getPolicyRetryInfo();
        Map map = updatedStepMetaData.getInfo();
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)$this$getCompletedManagedIndexMetaData, null, null, null, null, null, (Boolean)bl, (Boolean)bl2, null, (String)string, null, (ActionMetaData)updatedActionMetaData, (StepMetaData)stepMetaData2, (PolicyRetryInfoMetaData)policyRetryInfoMetaData, (Map)map, null, (long)0L, (long)0L, (int)115359, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuccessfulDelete(@NotNull ManagedIndexMetaData $this$isSuccessfulDelete) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuccessfulDelete, (String)"<this>");
        ActionMetaData actionMetaData = $this$isSuccessfulDelete.getActionMetaData();
        if (!Intrinsics.areEqual((Object)(actionMetaData == null ? null : actionMetaData.getName()), (Object)"delete")) return false;
        ActionMetaData actionMetaData2 = $this$isSuccessfulDelete.getActionMetaData();
        Intrinsics.checkNotNull((Object)actionMetaData2);
        if (actionMetaData2.getFailed()) return false;
        StepMetaData stepMetaData = $this$isSuccessfulDelete.getStepMetaData();
        if (!Intrinsics.areEqual((Object)(stepMetaData == null ? null : stepMetaData.getName()), (Object)"delete")) return false;
        StepMetaData stepMetaData2 = $this$isSuccessfulDelete.getStepMetaData();
        Intrinsics.checkNotNull((Object)stepMetaData2);
        if (stepMetaData2.getStepStatus() != Step.StepStatus.COMPLETED) return false;
        PolicyRetryInfoMetaData policyRetryInfoMetaData = $this$isSuccessfulDelete.getPolicyRetryInfo();
        if (policyRetryInfoMetaData == null) {
            return true;
        }
        if (!policyRetryInfoMetaData.getFailed()) return true;
        return false;
    }

    public static final boolean isFailed(@NotNull ManagedIndexMetaData $this$isFailed) {
        Intrinsics.checkNotNullParameter((Object)$this$isFailed, (String)"<this>");
        PolicyRetryInfoMetaData policyRetryInfoMetaData = $this$isFailed.getPolicyRetryInfo();
        if (policyRetryInfoMetaData == null ? false : policyRetryInfoMetaData.getFailed()) {
            return true;
        }
        ActionMetaData actionMetaData = $this$isFailed.getActionMetaData();
        return actionMetaData == null ? false : actionMetaData.getFailed();
    }

    public static final boolean isPolicyCompleted(@NotNull ManagedIndexMetaData $this$isPolicyCompleted) {
        Intrinsics.checkNotNullParameter((Object)$this$isPolicyCompleted, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isPolicyCompleted.getPolicyCompleted(), (Object)true);
    }

    public static final boolean shouldChangePolicy(@NotNull ManagedIndexConfig $this$shouldChangePolicy, @NotNull ManagedIndexMetaData managedIndexMetaData, @Nullable Action actionToExecute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldChangePolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managedIndexMetaData, (String)"managedIndexMetaData");
        if ($this$shouldChangePolicy.getChangePolicy() == null) {
            return false;
        }
        if ($this$shouldChangePolicy.getChangePolicy().isSafe()) {
            return true;
        }
        Action action = actionToExecute;
        if (Intrinsics.areEqual((Object)(action == null ? null : action.getType()), (Object)"transition")) {
            return true;
        }
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        return Intrinsics.areEqual((Object)(actionMetaData == null ? null : actionMetaData.getName()), (Object)"transition");
    }

    public static final boolean hasVersionConflict(@NotNull ManagedIndexMetaData $this$hasVersionConflict, @NotNull ManagedIndexConfig managedIndexConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$hasVersionConflict, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)managedIndexConfig, (String)"managedIndexConfig");
        return !Intrinsics.areEqual((Object)$this$hasVersionConflict.getPolicySeqNo(), (Object)managedIndexConfig.getPolicySeqNo()) || !Intrinsics.areEqual((Object)$this$hasVersionConflict.getPolicyPrimaryTerm(), (Object)managedIndexConfig.getPolicyPrimaryTerm());
    }

    public static final boolean hasDifferentJobInterval(@NotNull ManagedIndexConfig $this$hasDifferentJobInterval, int jobInterval) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDifferentJobInterval, (String)"<this>");
        Schedule schedule = $this$hasDifferentJobInterval.getSchedule();
        if (schedule instanceof IntervalSchedule) {
            return ((IntervalSchedule)schedule).getInterval() != jobInterval;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isSafeToChange(@NotNull Policy $this$isSafeToChange, @Nullable String stateName, @NotNull Policy newPolicy, @NotNull ChangePolicy changePolicy) {
        Object v1;
        State currentState;
        block9: {
            Object object;
            block8: {
                Intrinsics.checkNotNullParameter((Object)$this$isSafeToChange, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)newPolicy, (String)"newPolicy");
                Intrinsics.checkNotNullParameter((Object)changePolicy, (String)"changePolicy");
                if (stateName == null) {
                    return true;
                }
                if (changePolicy.getState() != null) {
                    return false;
                }
                for (Object object2 : (Iterable)$this$isSafeToChange.getStates()) {
                    State it = (State)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                    object = object2;
                    break block8;
                }
                object = null;
            }
            currentState = (State)object;
            for (Object object3 : (Iterable)newPolicy.getStates()) {
                State it = (State)object3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)stateName)) continue;
                v1 = object3;
                break block9;
            }
            v1 = null;
        }
        State newState = v1;
        if (currentState == null || newState == null) {
            return false;
        }
        if (currentState.getActions().size() != newState.getActions().size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = currentState.getActions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void action;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Action action2 = (Action)item$iv;
            int index2 = n;
            boolean bl = false;
            Action newStateAction = newState.getActions().get(index2);
            if (Intrinsics.areEqual((Object)action.getType(), (Object)newStateAction.getType())) continue;
            return false;
        }
        return true;
    }

    public static final boolean isAllowed(@NotNull Action $this$isAllowed, @NotNull List<String> allowList) {
        Intrinsics.checkNotNullParameter((Object)$this$isAllowed, (String)"<this>");
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        return allowList.contains($this$isAllowed.getType());
    }

    @NotNull
    public static final MetadataCheck checkMetadata(@Nullable ManagedIndexMetaData clusterStateMetadata, @Nullable Object configIndexMetadata, @Nullable String currentIndexUuid, @NotNull Logger logger) {
        String indexUuid2;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ManagedIndexMetaData managedIndexMetaData = clusterStateMetadata;
        String indexUuid1 = managedIndexMetaData == null ? null : managedIndexMetaData.getIndexUuid();
        Object object = configIndexMetadata;
        String string = object instanceof ManagedIndexMetaData ? ((ManagedIndexMetaData)configIndexMetadata).getIndexUuid() : (indexUuid2 = object instanceof Map ? ((Map)configIndexMetadata).get("index_uuid") : null);
        if (indexUuid1 != null && !Intrinsics.areEqual((Object)indexUuid1, (Object)currentIndexUuid) || indexUuid2 != null && !Intrinsics.areEqual((Object)indexUuid2, (Object)currentIndexUuid)) {
            return MetadataCheck.CORRUPT;
        }
        if (clusterStateMetadata != null) {
            Long l;
            if (configIndexMetadata == null) {
                return MetadataCheck.PENDING;
            }
            StepMetaData stepMetaData = clusterStateMetadata.getStepMetaData();
            Long t1 = stepMetaData == null ? null : Long.valueOf(stepMetaData.getStartTime());
            Object object2 = configIndexMetadata;
            if (object2 instanceof ManagedIndexMetaData) {
                StepMetaData stepMetaData2 = ((ManagedIndexMetaData)configIndexMetadata).getStepMetaData();
                l = stepMetaData2 == null ? null : Long.valueOf(stepMetaData2.getStartTime());
            } else if (object2 instanceof Map) {
                Map stepMetadata;
                Map map = stepMetadata = (Map)((Map)configIndexMetadata).get("step");
                l = map == null ? null : map.get("start_time");
            } else {
                l = null;
            }
            Long t2 = l;
            if (t1 != null && t2 != null && t1 > t2) {
                logger.warn("Cluster state metadata get updates after moved for [" + clusterStateMetadata.getIndex() + "]");
            }
        }
        return MetadataCheck.SUCCESS;
    }
}

