/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.explain;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.indexstatemanagement.model.SearchParams;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B=\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest;", "Lorg/opensearch/action/ActionRequest;", "indices", "", "", "local", "", "masterTimeout", "Lorg/opensearch/common/unit/TimeValue;", "searchParams", "Lorg/opensearch/indexmanagement/indexstatemanagement/model/SearchParams;", "showPolicy", "indexType", "(Ljava/util/List;ZLorg/opensearch/common/unit/TimeValue;Lorg/opensearch/indexmanagement/indexstatemanagement/model/SearchParams;ZLjava/lang/String;)V", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "(Lorg/opensearch/common/io/stream/StreamInput;)V", "getIndexType", "()Ljava/lang/String;", "getIndices", "()Ljava/util/List;", "getLocal", "()Z", "getMasterTimeout", "()Lorg/opensearch/common/unit/TimeValue;", "getSearchParams", "()Lorg/opensearch/indexmanagement/indexstatemanagement/model/SearchParams;", "getShowPolicy", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class ExplainRequest
extends ActionRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> indices;
    private final boolean local;
    @NotNull
    private final TimeValue masterTimeout;
    @NotNull
    private final SearchParams searchParams;
    private final boolean showPolicy;
    @NotNull
    private final String indexType;
    @NotNull
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot call explain on more than one index name/pattern when using a custom index type";

    @NotNull
    public final List<String> getIndices() {
        return this.indices;
    }

    public final boolean getLocal() {
        return this.local;
    }

    @NotNull
    public final TimeValue getMasterTimeout() {
        return this.masterTimeout;
    }

    @NotNull
    public final SearchParams getSearchParams() {
        return this.searchParams;
    }

    public final boolean getShowPolicy() {
        return this.showPolicy;
    }

    @NotNull
    public final String getIndexType() {
        return this.indexType;
    }

    public ExplainRequest(@NotNull List<String> indices, boolean local, @NotNull TimeValue masterTimeout, @NotNull SearchParams searchParams, boolean showPolicy, @NotNull String indexType) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)masterTimeout, (String)"masterTimeout");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Intrinsics.checkNotNullParameter((Object)indexType, (String)"indexType");
        this.indices = indices;
        this.local = local;
        this.masterTimeout = masterTimeout;
        this.searchParams = searchParams;
        this.showPolicy = showPolicy;
        this.indexType = indexType;
    }

    public ExplainRequest(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Object object = sin.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readStringList()");
        List list = object;
        boolean bl = sin.readBoolean();
        object = sin.readTimeValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readTimeValue()");
        List list2 = object;
        SearchParams searchParams = new SearchParams(sin);
        boolean bl2 = sin.readBoolean();
        object = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sin.readString()");
        this(list, bl, (TimeValue)list2, searchParams, bl2, (String)object);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Intrinsics.areEqual((Object)this.indexType, (Object)"_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, validationException);
        }
        return validationException;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeStringCollection((Collection)this.indices);
        out.writeBoolean(this.local);
        out.writeTimeValue(this.masterTimeout);
        this.searchParams.writeTo(out);
        out.writeBoolean(this.showPolicy);
        out.writeString(this.indexType);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/explain/ExplainRequest$Companion;", "", "()V", "MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

