/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.command;

import com.oracle.labs.mlrg.olcut.command.Command;
import com.oracle.labs.mlrg.olcut.command.CommandCompleter;
import com.oracle.labs.mlrg.olcut.command.CommandGroup;
import com.oracle.labs.mlrg.olcut.command.CommandInterface;
import com.oracle.labs.mlrg.olcut.command.CompleterCommandInterface;
import com.oracle.labs.mlrg.olcut.command.LayeredCommandInterpreter;
import com.oracle.labs.mlrg.olcut.command.MultiCommandArgumentCompleter;
import com.oracle.labs.mlrg.olcut.command.Optional;
import com.oracle.labs.mlrg.olcut.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class CommandInterpreter
extends Thread {
    private static final Logger logger = Logger.getLogger(CommandInterpreter.class.getName());
    public static final String STANDARD_COMMANDS_GROUP_NAME = "Standard";
    public static final String UNGROUPED_COMMANDS_GROUP_NAME = "Ungrouped";
    private static final String MSG_COMMAND_NOT_FOUND = "ERR  CMD_NOT_FOUND";
    protected Map<String, CommandInterface> commands = new TreeMap<String, CommandInterface>();
    protected Map<String, CommandGroupInternal> commandGroups = new TreeMap<String, CommandGroupInternal>();
    protected Deque<LayeredCommandInterpreter> interpreters = new LinkedList<LayeredCommandInterpreter>();
    int totalCommands = 0;
    private boolean parseQuotes = true;
    private String prompt;
    private String rawArguments;
    boolean done = false;
    private boolean trace = false;
    CommandHistory history = new CommandHistory();
    private BufferedReader in;
    private boolean inputIsFile;
    public PrintStream out;
    private String defaultCommand;
    private LineReader consoleReader = null;
    private Pattern layeredCommandPattern = Pattern.compile("(.*)\\.([^.]*)");
    private HashSet<Class<?>> supportedMethodParameters = new HashSet<Class>(Arrays.asList(String.class, String[].class, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE, File.class));
    private static Pattern historyPush = Pattern.compile("(.+):p");
    private static Pattern editPattern = Pattern.compile("\\^(.+?)\\^(.*?)\\^?");
    private static Pattern bbPattern = Pattern.compile("(!!)");

    public CommandInterpreter() {
        this(true);
    }

    public CommandInterpreter(boolean createNewShellEnvironment) {
        if (createNewShellEnvironment) {
            this.addStandardCommands();
            this.setupJLine();
        }
        this.out = System.out;
    }

    public CommandInterpreter(String inputFile) throws IOException {
        this.addStandardCommands();
        if (inputFile == null) {
            this.setupJLine();
        } else {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8));
            this.inputIsFile = true;
        }
        this.out = System.out;
    }

    protected void setupJLine() {
        try {
            String main = Util.getMainClassName();
            DefaultParser parser = new DefaultParser();
            parser.setEofOnUnclosedBracket(new DefaultParser.Bracket[]{DefaultParser.Bracket.CURLY, DefaultParser.Bracket.ROUND, DefaultParser.Bracket.SQUARE});
            parser.setEofOnUnclosedQuote(true);
            Path histFile = Util.getOlcutRoot().resolve("repl");
            TerminalBuilder terminalBuilder = TerminalBuilder.builder();
            LineReaderBuilder lineBuilder = LineReaderBuilder.builder();
            if (!main.isEmpty()) {
                histFile = histFile.resolve(main + ".history");
                lineBuilder.appName(main);
                terminalBuilder.name(main);
            } else {
                histFile = histFile.resolve("repl.history");
            }
            terminalBuilder.system(true);
            Terminal terminal = terminalBuilder.build();
            lineBuilder.terminal(terminal);
            lineBuilder.parser((Parser)parser);
            lineBuilder.completer((Completer)new MultiCommandArgumentCompleter(this.commands, this.interpreters));
            lineBuilder.option(LineReader.Option.EMPTY_WORD_OPTIONS, true);
            lineBuilder.option(LineReader.Option.COMPLETE_IN_WORD, true);
            lineBuilder.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
            lineBuilder.option(LineReader.Option.HISTORY_BEEP, false);
            lineBuilder.variable("history-file", (Object)histFile.toAbsolutePath().toString());
            lineBuilder.history((History)new DefaultHistory());
            this.consoleReader = lineBuilder.build();
        }
        catch (IOException e) {
            logger.info("Failed to load JLine, falling back to System.in");
            this.in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        }
    }

    public LineReader getConsoleReader() {
        return this.consoleReader;
    }

    public void setParseQuotes(boolean parseQuotes) {
        this.parseQuotes = parseQuotes;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setDefaultCommand(String defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    private void addStandardCommands() {
        StandardCommands stdCommands = new StandardCommands();
        this.add(stdCommands);
        this.addGroup(UNGROUPED_COMMANDS_GROUP_NAME, "Commands not in other groups");
    }

    protected void dumpCommands() {
        int count = this.dumpGroup(this.commandGroups.get(STANDARD_COMMANDS_GROUP_NAME), 0);
        for (CommandGroupInternal cg : this.commandGroups.values()) {
            if (cg.getGroupName().equals(STANDARD_COMMANDS_GROUP_NAME)) continue;
            count = this.dumpGroup(cg, count);
        }
        for (LayeredCommandInterpreter lci : this.interpreters) {
            this.putResponse(String.format("Commands from %s labeled with .%s", lci.getLayerName(), lci.getLayerTag()));
            lci.dumpCommands();
        }
    }

    protected int dumpGroup(CommandGroupInternal cg, int count) {
        this.putResponse(String.format("%s group: %s", cg.getGroupName(), cg.getDescription()));
        for (String cmdName : cg) {
            String help = this.commands.get(cmdName).getHelp();
            this.putResponse(String.format("%3d) %s - %s", count, cmdName, help));
            ++count;
        }
        return count;
    }

    String getCommandByNumber(int which) {
        int count = 0;
        CommandGroupInternal scg = this.commandGroups.get(STANDARD_COMMANDS_GROUP_NAME);
        for (String cmdName : scg) {
            if (count == which) {
                return cmdName;
            }
            ++count;
        }
        for (CommandGroupInternal cg : this.commandGroups.values()) {
            if (cg.getGroupName().equals(STANDARD_COMMANDS_GROUP_NAME)) continue;
            for (String cmdName : cg) {
                if (count == which) {
                    return cmdName;
                }
                ++count;
            }
        }
        return null;
    }

    public void addGroup(String groupName, String description) {
        this.addGroup(groupName, description, true);
    }

    public void addGroup(String groupName, String description, boolean keepSorted) {
        CommandGroupInternal cg = this.commandGroups.get(groupName);
        if (cg != null) {
            return;
        }
        this.commandGroups.put(groupName, new CommandGroupInternal(groupName, description, keepSorted));
    }

    public void add(String commandName, String groupName, CommandInterface command) {
        if (groupName == null) {
            groupName = UNGROUPED_COMMANDS_GROUP_NAME;
        }
        this.commands.put(commandName, command);
        CommandGroupInternal cg = this.commandGroups.get(groupName);
        if (cg == null) {
            logger.warning(String.format("Unknown command group name: %s (from %s)", groupName, commandName));
            cg = new CommandGroupInternal(groupName, "", false);
            this.commandGroups.put(groupName, cg);
        }
        cg.add(commandName);
    }

    public void add(String name, CommandInterface command) {
        this.add(name, null, command);
    }

    public void add(CommandGroup group) {
        Method[] methods;
        this.addGroup(group.getName(), group.getDescription());
        for (Method m : methods = group.getClass().getMethods()) {
            String methodName = group.getClass().getName() + "#" + m.getName();
            Command cmd = m.getAnnotation(Command.class);
            if (cmd == null) continue;
            Parameter[] params = m.getParameters();
            if (params.length == 0 || params[0].getType() != CommandInterpreter.class) {
                logger.warning(methodName + " must have CommandInterpreter for its first parameter");
                continue;
            }
            for (int i = 1; i < params.length; ++i) {
                if (!this.supportedMethodParameters.contains(params[i].getType()) && !params[i].getType().isEnum()) {
                    logger.warning(methodName + " has unsupported parameter type " + params[i].getType().getSimpleName());
                }
                if (params[i].getType() != String[].class || i == params.length - 1) continue;
                logger.warning(String.format("%s has String[] parameter which is not last", methodName));
            }
            boolean foundOptional = false;
            for (Parameter p : params) {
                Optional opt = p.getAnnotation(Optional.class);
                if (foundOptional && opt == null) {
                    logger.warning(methodName + " has non-optional parameter following optional parameter.");
                    continue;
                }
                if (opt == null) continue;
                foundOptional = true;
            }
            if (m.getReturnType() != String.class) {
                logger.warning(methodName + " has wrong return type.  Expected String");
                continue;
            }
            Method completerMtd = null;
            if (!cmd.completers().isEmpty()) {
                try {
                    completerMtd = group.getClass().getMethod(cmd.completers(), null);
                }
                catch (NoSuchMethodException e) {
                    logger.warning(methodName + " references a non-existant completer method: " + cmd.completers());
                }
            }
            try {
                completerMtd = group.getClass().getMethod(m.getName() + "Completers", null);
            }
            catch (NoSuchMethodException e) {
                logger.finer(methodName + " has no completers");
            }
            CommandInterface ci = this.methodToCommand(m, cmd.usage(), group, completerMtd);
            this.add(m.getName(), group.getName(), ci);
            if (cmd.alias().isEmpty()) continue;
            this.addAlias(m.getName(), cmd.alias());
        }
    }

    private CommandInterface methodToCommand(final Method m, final String usage, final CommandGroup group, final Method cm) {
        if (cm != null) {
            if (cm.getReturnType() != Completer[].class) {
                logger.warning(group.getClass().getName() + "#" + cm.getName() + " has wrong return type.  Expected Completer[]");
            }
            CompleterCommandInterface ci = new CompleterCommandInterface(){

                @Override
                public String execute(CommandInterpreter ci, String[] args) throws Exception {
                    return CommandInterpreter.this.invokeMethod(m, usage, group, ci, args);
                }

                @Override
                public String getHelp() {
                    return usage;
                }

                @Override
                public Completer[] getCompleters() {
                    try {
                        return (Completer[])cm.invoke((Object)group, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        logger.log(Level.WARNING, "Couldn't invoke " + group.getClass().getName() + "#" + cm.getName(), e);
                        return null;
                    }
                }
            };
            return ci;
        }
        CommandInterface ci = new CommandInterface(){

            @Override
            public String execute(CommandInterpreter ci, String[] args) throws Exception {
                return CommandInterpreter.this.invokeMethod(m, usage, group, ci, args);
            }

            @Override
            public String getHelp() {
                return usage;
            }
        };
        return ci;
    }

    private String invokeMethod(Method m, String usage, CommandGroup group, CommandInterpreter ci, String[] args) throws Exception {
        Parameter[] params = m.getParameters();
        if (params.length > 1 && params[1].getType() == String[].class && m.getParameterCount() == 2) {
            return (String)m.invoke((Object)group, ci, Arrays.copyOfRange(args, 1, args.length));
        }
        if (m.getParameterCount() != args.length) {
            int minParams = 0;
            for (Parameter p : params) {
                Optional opt = p.getAnnotation(Optional.class);
                if (opt != null) continue;
                ++minParams;
            }
            Parameter p = params[params.length - 1];
            if (p.getType() == String[].class) {
                --minParams;
            }
            if (args.length - 1 < --minParams) {
                String paramStr = m.toString();
                paramStr = (paramStr = paramStr.substring(paramStr.indexOf(40) + 1, paramStr.indexOf(41))).indexOf(44) < 0 ? "<empty>" : paramStr.substring(paramStr.indexOf(44) + 1);
                return String.format("Incorrect number of arguments.  Found %d, expected %d: %s%nUsage: %s", args.length - 1, minParams, paramStr, usage);
            }
        }
        int numArgs = m.getParameterCount();
        Object[] invokeParams = new Object[numArgs];
        invokeParams[0] = ci;
        for (int i = 1; i < numArgs; ++i) {
            Optional opt;
            String arg = args.length - 1 < i ? ((opt = params[i].getAnnotation(Optional.class)) != null ? opt.val() : "") : args[i];
            Class<?> currParam = params[i].getType();
            try {
                if (arg.equals("<null>")) {
                    invokeParams[i] = null;
                    continue;
                }
                if (currParam == String.class) {
                    invokeParams[i] = arg;
                    continue;
                }
                if (currParam == String[].class) {
                    if (numArgs > args.length) {
                        invokeParams[i] = new String[0];
                        break;
                    }
                    invokeParams[i] = Arrays.copyOfRange(args, i, args.length);
                    break;
                }
                if (currParam == Integer.class || currParam == Integer.TYPE) {
                    invokeParams[i] = Integer.parseInt(arg);
                    continue;
                }
                if (currParam == Short.class || currParam == Short.TYPE) {
                    invokeParams[i] = Short.parseShort(arg);
                    continue;
                }
                if (currParam == Long.class || currParam == Long.TYPE) {
                    invokeParams[i] = Long.parseLong(arg);
                    continue;
                }
                if (currParam == Float.class || currParam == Float.TYPE) {
                    invokeParams[i] = Float.valueOf(Float.parseFloat(arg));
                    continue;
                }
                if (currParam == Double.class || currParam == Double.TYPE) {
                    invokeParams[i] = Double.parseDouble(arg);
                    continue;
                }
                if (currParam.isEnum()) {
                    Object tmp = Enum.valueOf(currParam, arg.toUpperCase());
                    invokeParams[i] = tmp;
                    continue;
                }
                if (currParam == Boolean.class || currParam == Boolean.TYPE) {
                    invokeParams[i] = Boolean.parseBoolean(arg);
                    continue;
                }
                if (currParam == File.class) {
                    invokeParams[i] = new File(arg);
                    continue;
                }
                return String.format("Unsupported method argument: %s in %s#%s", currParam.getName(), group.getClass().getName(), m.getName());
            }
            catch (NumberFormatException e) {
                return String.format("Invalid value (%s) for parameter of type %s%nUsage: %s", Arrays.toString(args), currParam.getName(), usage);
            }
        }
        return (String)m.invoke((Object)group, invokeParams);
    }

    public void addAlias(String command, String alias) {
        this.commands.put(alias, this.commands.get(command));
    }

    public void add(Map<String, CommandInterface> newCommands) {
        this.commands.putAll(newCommands);
    }

    public void add(LayeredCommandInterpreter lci) {
        lci.setOutput(this.out);
        lci.setParseQuotes(this.parseQuotes);
        lci.setTrace(this.trace);
        this.interpreters.addFirst(lci);
    }

    public void remove(String layerTag) {
        Iterator<LayeredCommandInterpreter> i = this.interpreters.iterator();
        while (i.hasNext()) {
            LayeredCommandInterpreter lci = i.next();
            if (!lci.getLayerTag().equals(layerTag)) continue;
            i.remove();
            break;
        }
    }

    public synchronized void putResponse(String response) {
        if (response != null && response.length() > 0) {
            this.out.println(response);
        }
    }

    public PrintStream getOutput() {
        return this.out;
    }

    public void setOutput(PrintStream out) {
        this.out = out;
    }

    protected void onExit() {
        this.execute("on_exit");
        for (LayeredCommandInterpreter lci : this.interpreters) {
            CommandInterface ci = (CommandInterface)lci.commands.get("on_exit");
            try {
                if (ci == null) continue;
                ci.execute(this, new String[]{"on_exit"});
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, String.format("Error on close for %s", lci.getLayerName()), ex);
            }
        }
        this.close();
        this.out.println("----------\n");
        if (this.out != System.out) {
            this.out.close();
        }
    }

    public String execute(String[] args) {
        return this.execute(args, true);
    }

    private String execute(String[] args, boolean first) {
        String response = "";
        CommandInterface ci = null;
        if (args.length > 0) {
            String command = args[0];
            CommandGroupInternal cg = this.commandGroups.get(STANDARD_COMMANDS_GROUP_NAME);
            if (cg.contains(command)) {
                ci = this.commands.get(args[0]);
            }
            if (ci == null) {
                Matcher m = this.layeredCommandPattern.matcher(command);
                if (m.matches()) {
                    String layeredName = m.group(1);
                    String layerTag = m.group(2);
                    for (LayeredCommandInterpreter lci : this.interpreters) {
                        if (!lci.getLayerTag().equals(layerTag)) continue;
                        String[] newArgs = Arrays.copyOf(args, args.length);
                        newArgs[0] = layeredName;
                        return lci.execute(newArgs);
                    }
                }
                for (LayeredCommandInterpreter lci : this.interpreters) {
                    ci = (CommandInterface)lci.commands.get(command);
                    if (ci == null) continue;
                    break;
                }
            }
            if (ci == null) {
                ci = this.commands.get(args[0]);
            }
            if (ci != null) {
                try {
                    response = ci.execute(this, args);
                }
                catch (Exception ex) {
                    response = "ERR command exception " + ex.getMessage();
                    ex.printStackTrace(this.out);
                }
            } else {
                if (first && this.defaultCommand != null && !command.equals("on_exit")) {
                    String[] newArgs = new String[args.length + 1];
                    newArgs[0] = this.defaultCommand;
                    System.arraycopy(args, 0, newArgs, 1, args.length);
                    return this.execute(newArgs, false);
                }
                response = MSG_COMMAND_NOT_FOUND;
            }
            ++this.totalCommands;
        }
        return response;
    }

    public String execute(String cmdString) {
        if (this.trace) {
            this.out.println("Execute: " + cmdString);
        }
        if (this.inputIsFile) {
            this.out.println(cmdString);
        }
        return this.execute(this.parseMessage(cmdString));
    }

    protected String[] parseMessage(String message) {
        ArrayList<String> words = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(message));
        st.resetSyntax();
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        if (this.parseQuotes) {
            st.quoteChar(34);
        }
        st.commentChar(35);
        try {
            while (true) {
                int tokenType;
                if ((tokenType = st.nextToken()) == -3) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == 39 || tokenType == 34) {
                    words.add(st.sval);
                    continue;
                }
                if (tokenType == -2) {
                    this.out.println("Unexpected numeric token!");
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.rawArguments = message.substring(((String)words.get(0)).length()).trim();
        return words.toArray(new String[0]);
    }

    public String getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                String message = this.getInputLine();
                if (message == null) break;
                if (this.trace) {
                    this.out.println("\n----------");
                    this.out.println("In : " + message);
                }
                if ((message = message.trim()).length() <= 0) continue;
                this.putResponse(this.execute(message));
            }
            catch (IOException e) {
                this.out.println("Exception: CommandInterpreter.run()");
                break;
            }
            catch (UserInterruptException e) {
                this.out.println();
            }
            catch (EndOfFileException e) {
                // empty catch block
                break;
            }
        }
        this.onExit();
    }

    private String getInputLine() throws IOException {
        boolean error;
        boolean echo;
        boolean justPush;
        String message;
        block20: {
            if (this.consoleReader != null) {
                logger.log(Level.FINER, "In the right place");
                String message2 = this.consoleReader.readLine(this.prompt);
                logger.log(Level.FINER, "Read line");
                this.history.add(message2);
                return message2;
            }
            message = this.in.readLine();
            if (message == null) {
                return null;
            }
            justPush = false;
            echo = false;
            error = false;
            Matcher m = historyPush.matcher(message);
            if (m.matches()) {
                justPush = true;
                echo = true;
                message = m.group(1);
            }
            if (message.startsWith("^")) {
                m = editPattern.matcher(message);
                if (m.matches()) {
                    String orig = m.group(1);
                    String sub = m.group(2);
                    try {
                        Pattern pat = Pattern.compile(orig);
                        Matcher subMatcher = pat.matcher(this.history.getLast(0));
                        if (subMatcher.find()) {
                            message = subMatcher.replaceFirst(sub);
                            echo = true;
                            break block20;
                        }
                        error = true;
                        this.putResponse(message + ": substitution failed");
                    }
                    catch (PatternSyntaxException pse) {
                        error = true;
                        this.putResponse("Bad regexp: " + pse.getDescription());
                    }
                } else {
                    error = true;
                    this.putResponse("bad substitution syntax, use ^old^new^");
                }
            } else {
                m = bbPattern.matcher(message);
                if (m.find()) {
                    message = m.replaceAll(this.history.getLast(0));
                    echo = true;
                } else if (message.startsWith("!")) {
                    if (message.matches("!\\d+")) {
                        int which = Integer.parseInt(message.substring(1));
                        message = this.history.get(which);
                    } else if (message.matches("!-\\d+")) {
                        int which = Integer.parseInt(message.substring(2));
                        message = this.history.getLast(which - 1);
                    } else {
                        message = this.history.findLast(message.substring(1));
                    }
                    echo = true;
                }
            }
        }
        if (error) {
            return "";
        }
        if (message.length() > 0) {
            this.history.add(message);
        }
        if (echo) {
            this.putResponse(message);
        }
        return justPush ? "" : message;
    }

    public void close() {
        try {
            this.consoleReader.getHistory().save();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to write history", e);
        }
        this.done = true;
    }

    private void printPrompt() {
        if (this.prompt != null) {
            this.out.print(this.prompt);
        }
    }

    public boolean load(String filename) {
        return this.load(new File(filename));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(File file) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                String response = this.execute(inputLine);
                if (!response.equals("OK")) {
                    this.putResponse(response);
                }
                if (!response.equals(MSG_COMMAND_NOT_FOUND)) continue;
                this.putResponse("Failed to find a command, stopping.");
                break;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean pload(String filename, int numThreads) {
        return this.pload(new File(filename), numThreads);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pload(File file, int numThreads) {
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String inputLine;
            while ((inputLine = br.readLine()) != null) {
                String currLine = inputLine;
                Callable<Boolean> cmd = () -> {
                    String response = this.execute(currLine);
                    if (!response.equals("OK")) {
                        this.putResponse(response);
                    }
                    return !response.equals(MSG_COMMAND_NOT_FOUND);
                };
                exec.submit(cmd);
            }
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.DAYS);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException ex) {
            logger.info("Parallel Load did not shut down properly");
            return false;
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public static void main(String[] args) {
        CommandInterpreter ci = new CommandInterpreter();
        try {
            System.out.println("Welcome to the Command interpreter test program");
            ci.setPrompt("CI> ");
            ci.run();
            System.out.println("Goodbye!");
        }
        catch (Throwable t) {
            System.out.println(t);
        }
    }

    class StandardCommands
    implements CommandGroup {
        public Completer commandCompleter;

        StandardCommands() {
            this.commandCompleter = new CommandCompleter(CommandInterpreter.this.commands, CommandInterpreter.this.interpreters);
        }

        @Command(usage="lists available commands")
        public String help(CommandInterpreter ci) {
            ci.dumpCommands();
            return "";
        }

        @Command(usage="shows command history")
        public String history(CommandInterpreter ci) {
            ci.history.dump();
            return "";
        }

        @Command(usage="shows command status")
        public String status(CommandInterpreter ci) {
            ci.putResponse("Total number of commands: " + ci.totalCommands);
            return "";
        }

        @Command(usage="Echos the input back after the line processing")
        public String echo(CommandInterpreter ci, String[] args) {
            ci.putResponse(String.join((CharSequence)" ", args));
            return "";
        }

        @Command(usage="Print the args")
        public String pargs(CommandInterpreter ci, String[] args) {
            ci.putResponse(String.format("args: %s", Arrays.toString(args)));
            return "";
        }

        @Command(usage="Execute a command by number", alias="m")
        public String menu(CommandInterpreter ci, int which, String[] args) {
            String cmd = ci.getCommandByNumber(which);
            if (cmd == null) {
                return "can't find that command";
            }
            String[] newArgs = new String[1 + args.length];
            newArgs[0] = cmd;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return ci.execute(newArgs);
        }

        @Command(usage="exit the shell", alias="exit")
        public String quit(CommandInterpreter ci) {
            ci.done = true;
            return "";
        }

        @Command(usage="displays OLCUT version information")
        public String version(CommandInterpreter ci) {
            ci.putResponse("Command Interpreter - OLCUT Version 5.2.0");
            return "";
        }

        @Command(usage="Suggests to the runtime it should perform garbage colletion")
        public String gc(CommandInterpreter ci) {
            Runtime.getRuntime().gc();
            return "";
        }

        @Command(usage="shows memory statistics")
        public String memory(CommandInterpreter ci) {
            long totalMem = Runtime.getRuntime().totalMemory();
            long freeMem = Runtime.getRuntime().freeMemory();
            ci.putResponse("Free Memory  : " + (double)freeMem / 1048576.0 + " mbytes");
            ci.putResponse("Total Memory : " + (double)totalMem / 1048576.0 + " mbytes");
            return "";
        }

        @Command(usage="pauses for a given number of seconds, delay <time>")
        public String delay(CommandInterpreter ci, float time) {
            try {
                Thread.sleep((long)(time * 1000.0f));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return "";
        }

        @Command(usage="adds a pseudonym of shorthand term for a command", completers="aliasCompleters")
        public String alias(CommandInterpreter ci, String alias, String cmd) {
            ci.addAlias(cmd, alias);
            return "";
        }

        public Completer[] aliasCompleters() {
            return new Completer[]{new NullCompleter(), this.commandCompleter};
        }

        @Command(usage="repeatedly execute a command, repeat <int> <command> <args>")
        public String repeat(CommandInterpreter ci, int count, String[] args) {
            if (args.length >= 1) {
                for (int i = 0; i < count; ++i) {
                    ci.putResponse(ci.execute(args));
                }
            } else {
                ci.putResponse("Usage: repeat count command args");
            }
            return "";
        }

        public Completer[] repeatCompleters() {
            return new Completer[]{new NullCompleter(), this.commandCompleter};
        }

        @Command(usage="Redirect a single command to a file, redirect <file-name> <command> <args>")
        public String redirect(CommandInterpreter ci, File outputFile, String[] args) {
            try {
                PrintStream oldOut = ci.out;
                ci.out = new PrintStream(outputFile, "utf-8");
                ci.putResponse(ci.execute(args));
                ci.out.close();
                ci.out = oldOut;
            }
            catch (IOException ioe) {
                System.err.println("Can't write to " + args[1] + " " + ioe);
            }
            return "";
        }

        public Completer[] redirectCompleters() {
            return new Completer[]{new Completers.FileNameCompleter(), this.commandCompleter};
        }

        @Command(usage="Load and execute commands from a file", completers="filenameCompleters")
        public String load(CommandInterpreter ci, File file) {
            if (!ci.load(file)) {
                ci.putResponse("load: trouble loading " + file.toString());
            }
            return "";
        }

        @Command(usage="load and execute commands from a file in parallel, pload <file> <numThreads>", completers="filenameCompleters")
        public String pload(CommandInterpreter ci, File file, int numThreads) {
            if (numThreads < 1) {
                ci.putResponse("pload: supply a positive number of threads, recieved " + numThreads);
            }
            if (!ci.pload(file, numThreads)) {
                ci.putResponse("pload: trouble loading " + file.toString());
            }
            return "";
        }

        @Command(usage="execute multiple commands on a single line, each command separated by ';'")
        public String chain(CommandInterpreter ci, String ... args) {
            if (args.length > 1) {
                String[] subargs = new String[args.length - 1];
                ArrayList<String[]> commands = new ArrayList<String[]>(5);
                int count = 0;
                for (int i = 1; i < args.length; ++i) {
                    if (args[i].equals(";")) {
                        if (count <= 0) continue;
                        String[] trimmedArgs = new String[count];
                        System.arraycopy(subargs, 0, trimmedArgs, 0, trimmedArgs.length);
                        commands.add(trimmedArgs);
                        count = 0;
                        continue;
                    }
                    subargs[count++] = args[i];
                }
                if (count > 0) {
                    String[] trimmedArgs = new String[count];
                    System.arraycopy(subargs, 0, trimmedArgs, 0, trimmedArgs.length);
                    commands.add(trimmedArgs);
                }
                for (String[] i : commands) {
                    ci.putResponse(ci.execute(i));
                }
            } else {
                ci.putResponse("Usage: chain cmd1 ; cmd2 ; cmd3 ");
            }
            return "";
        }

        public Completer[] timeCompleters() {
            return new Completer[]{this.commandCompleter};
        }

        @Command(usage="report the time it takes to run a commmand", completers="timeCompleters")
        public String time(CommandInterpreter ci, String[] args) {
            long startTime = System.currentTimeMillis();
            ci.putResponse(ci.execute(args));
            long endTime = System.currentTimeMillis();
            ci.putResponse("Time: " + (double)(endTime - startTime) / 1000.0 + " seconds");
            return "";
        }

        @Command(usage="report the time it takes to run a command in milliseconds", completers="timeCompleters")
        public String mstime(CommandInterpreter ci, String[] args) {
            if (args.length > 1) {
                long startTime = System.nanoTime();
                ci.putResponse(ci.execute(args));
                ci.putResponse(String.format("Time: %.3f ms", (double)(System.nanoTime() - startTime) / 1000000.0));
            } else {
                ci.putResponse("Usage: mstime cmd [args]");
            }
            return "";
        }

        @Command(usage="Redirects all subsequent commands to the given file.", completers="filenameCompleters")
        public String setoutput(CommandInterpreter ci, File outputFile) throws Exception {
            ci.out = new PrintStream(outputFile, "utf-8");
            return "";
        }

        public Completer[] filenameCompleters() {
            return new Completer[]{new Completers.FileNameCompleter()};
        }

        @Command(usage="resets the output to be System.out")
        public String unredir(CommandInterpreter ci) {
            if (ci.out != System.out) {
                ci.out.close();
            }
            ci.out = System.out;
            return "";
        }

        @Command(usage="<LogLevel> [<LoggerName>] - sets the logging level for a logger, if specified, or sets the root handler level")
        public String setLogLevel(CommandInterpreter ci, String level, @Optional(val="") String loggerName) {
            Handler[] handlers;
            Level logLevel = null;
            try {
                logLevel = Level.parse(level);
            }
            catch (IllegalArgumentException e) {
                return "Unknown log level: " + level;
            }
            if (!loggerName.isEmpty()) {
                block11: {
                    try {
                        Class.forName(loggerName);
                    }
                    catch (ClassNotFoundException e) {
                        if (Arrays.stream(Package.getPackages()).anyMatch(p -> p.getName().startsWith(loggerName) && (p.getName().equals(loggerName) || p.getName().charAt(loggerName.length()) == '.'))) break block11;
                        ci.out.println("Warning: \"" + loggerName + "\" doesn't appear to be a class or package name");
                    }
                }
                Logger target = Logger.getLogger(loggerName);
                target.setLevel(logLevel);
            }
            if ((handlers = Logger.getLogger("").getHandlers()) == null || handlers.length <= 0) {
                return "No root log handlers defined.";
            }
            Level currLevel = handlers[0].getLevel();
            if (loggerName.isEmpty() || logLevel.intValue() < currLevel.intValue()) {
                for (Handler h : handlers) {
                    h.setLevel(logLevel);
                }
            } else if (!loggerName.isEmpty() && logLevel.intValue() > currLevel.intValue()) {
                ci.out.println(logLevel.toString() + " is less fine than current " + currLevel.toString() + ", won't automatically deescalate the Handler level");
            }
            if (loggerName.isEmpty()) {
                return "Set root log handlers to " + logLevel.toString();
            }
            return "Log level set to " + logLevel.toString() + " for " + loggerName;
        }

        @Override
        public String getName() {
            return CommandInterpreter.STANDARD_COMMANDS_GROUP_NAME;
        }

        @Override
        public String getDescription() {
            return "Standard commands";
        }
    }

    protected static class CommandGroupInternal
    implements Iterable<String> {
        private String groupName;
        private String description;
        private Set<String> commands;

        public CommandGroupInternal(String groupName, String description, boolean keepSorted) {
            this.groupName = groupName;
            this.description = description;
            this.commands = keepSorted ? new TreeSet<String>() : new LinkedHashSet<String>();
        }

        public Set<String> getCommands() {
            return this.commands;
        }

        public String getDescription() {
            return this.description;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean contains(String commandName) {
            return this.commands.contains(commandName);
        }

        public void add(String commandName) {
            this.commands.add(commandName);
        }

        @Override
        public Iterator<String> iterator() {
            return this.commands.iterator();
        }
    }

    class CommandHistory {
        private List<String> history = new ArrayList<String>(100);

        CommandHistory() {
        }

        public void add(String command) {
            this.history.add(command);
        }

        public String getLast(int offset) {
            if (this.history.size() > offset) {
                return this.history.get(this.history.size() - 1 - offset);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String get(int which) {
            if (this.history.size() > which) {
                return this.history.get(which);
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public String findLast(String match) {
            for (int i = this.history.size() - 1; i >= 0; --i) {
                String cmd = this.get(i);
                if (!cmd.startsWith(match)) continue;
                return cmd;
            }
            CommandInterpreter.this.putResponse("command not found");
            return "";
        }

        public void dump() {
            for (int i = 0; i < this.history.size(); ++i) {
                String cmd = this.get(i);
                CommandInterpreter.this.putResponse(i + " " + cmd);
            }
        }
    }
}

